/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl.jms;

import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventCallback;
import com.huawei.uflight.event.client.impl.IEventIDGenerator;
import com.huawei.uflight.event.client.impl.IRemoteEventObserver;
import com.huawei.uflight.event.client.impl.IRemoteMsgGateway;
import com.huawei.uflight.event.client.impl.jms.JMSConnectionWrapper;
import com.huawei.uflight.event.client.impl.jms.JMSMessage;
import com.huawei.uflight.event.client.impl.jms.JMSMessageHelper;
import com.huawei.uflight.event.client.impl.support.Scheduler;
import com.huawei.uflight.event.client.impl.support.TimerQueue;
import com.huawei.uflight.event.process.ProcessInfo;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSGateway
implements IRemoteMsgGateway {
    private final JMSConnectionWrapper connection;
    private final TimerQueue timerQueue;
    private IEventIDGenerator eventIDGenerator;
    private Scheduler executor;
    private static Logger logger = LoggerFactory.getLogger(JMSGateway.class);
    private ConcurrentHashMap<Long, IEventCallback> m_pendentRequest = new ConcurrentHashMap();

    public JMSGateway(String serverURL, Scheduler executor, TimerQueue timer) {
        this.executor = executor;
        this.timerQueue = timer;
        this.connection = new JMSConnectionWrapper(this, serverURL, timer);
    }

    public void start() {
        this.eventIDGenerator = new IEventIDGenerator(){
            private AtomicInteger id = new AtomicInteger(0);

            @Override
            public long generate() {
                return this.id.getAndIncrement();
            }
        };
        this.connection.connect();
    }

    @Override
    public void registerHandler(IRemoteEventObserver observer) {
        this.connection.registerConsumer(observer);
    }

    @Override
    public void removeHandler(IRemoteEventObserver observer) {
        this.connection.removeConsumer(observer);
    }

    private JMSMessage getMsg(Message nativeMsg) {
        return JMSMessageHelper.decodeProtocolMsg(nativeMsg);
    }

    void handleResponseMsg(Message nativeMsg) {
        HashMap<String, Object> ctlMsg = JMSMessageHelper.decodeControlMsg(nativeMsg);
        long eventID = 0L;
        int errorCode = 0;
        JMSMessage msg = null;
        if (ctlMsg != null) {
            eventID = (Long)ctlMsg.get("eventID");
            errorCode = (Integer)ctlMsg.get("errorCode");
        } else {
            msg = JMSMessageHelper.decodeProtocolMsg(nativeMsg);
            if (msg != null && msg.getType() == 3) {
                eventID = msg.getEventID();
                errorCode = msg.getErrorCode();
            } else {
                return;
            }
        }
        IEventCallback observer = this.removePendentMsg(eventID);
        if (null == observer) {
            return;
        }
        if (errorCode != 0) {
            observer.handleResponse(new EventResponse(errorCode));
        } else {
            EventResponse response = JMSMessageHelper.getResponse(msg);
            observer.handleResponse(response);
        }
    }

    void handleRequestMsg(Message msg, final IRemoteEventObserver observer) {
        final JMSMessage jmsMsg = this.getMsg(msg);
        final IEvent request = JMSMessageHelper.getRequest(jmsMsg);
        if (null == request) {
            logger.error("decode request-message failed, msg =" + msg + msg);
            return;
        }
        if (jmsMsg.getType() == 2) {
            this.executor.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    observer.handleNotify(request);
                }
            });
        } else if (jmsMsg.getType() == 1) {
            this.executor.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    EventResponse response = observer.handleRequest(request);
                    JMSGateway.this.responseMsg(jmsMsg, response, null);
                }
            });
        } else {
            logger.error("invalid request-message type = " + jmsMsg.getType());
        }
    }

    @Override
    public void sendMsg(IEvent ev, int timeout, final IEventCallback observer, ProcessInfo dest) {
        final JMSMessage jmsMsg = JMSMessageHelper.newRequestMsg(ev, timeout, dest);
        jmsMsg.setEventID(this.eventIDGenerator.generate());
        jmsMsg.setCommitTime(System.currentTimeMillis());
        jmsMsg.setResponseTopic(this.connection.getResponseTopic());
        this.addPendentMsg(jmsMsg.getEventID(), observer);
        this.timerQueue.scheduleTimer(new Runnable(){

            @Override
            public void run() {
                JMSGateway.this.removePendentMsg(jmsMsg.getEventID());
                observer.handleResponse(new EventResponse(-3));
            }
        }, timeout * 1000);
        this.connection.sendMsg(ev.getTopic(), jmsMsg);
    }

    private void responseMsg(JMSMessage request, EventResponse response, ProcessInfo sendPort) {
        JMSMessage responseMsg = JMSMessageHelper.newResponseMsg(request, response, sendPort);
        this.publishTopic(responseMsg.getResponseTopic(), responseMsg);
    }

    @Override
    public void publishTopic(String topic, JMSMessage msg) {
        this.connection.sendMsg(topic, msg);
    }

    private IEventCallback removePendentMsg(long eventID) {
        return this.m_pendentRequest.remove(eventID);
    }

    private void addPendentMsg(long eventID, IEventCallback observer) {
        this.m_pendentRequest.put(eventID, observer);
    }

    public void stop() {
        this.connection.close();
    }
}

