/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl.jms;

import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.impl.IRemoteEventObserver;
import com.huawei.uflight.event.client.impl.jms.JMSConsumerWrapper;
import com.huawei.uflight.event.client.impl.jms.JMSGateway;
import com.huawei.uflight.event.client.impl.jms.JMSMessage;
import com.huawei.uflight.event.client.impl.jms.JMSMessageHelper;
import com.huawei.uflight.event.client.impl.support.TimerQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSConnectionWrapper {
    private volatile Connection connectionImp;
    private volatile boolean isConnected = false;
    private static Logger logger = LoggerFactory.getLogger(JMSConnectionWrapper.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final TimerQueue timerQueue;
    private static final int RECONNECTINTERVAL = 10000;
    private Map<IRemoteEventObserver, JMSConsumerWrapper> m_observers = new HashMap<IRemoteEventObserver, JMSConsumerWrapper>();
    private ActiveMQConnectionFactory connectionfactory = null;
    private final JMSGateway gateWay;
    private volatile String m_responseTopic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConsumer(final IRemoteEventObserver observer) {
        Map<IRemoteEventObserver, JMSConsumerWrapper> map = this.m_observers;
        synchronized (map) {
            if (this.m_observers.containsKey(observer)) {
                return;
            }
            JMSConsumerWrapper consumer = new JMSConsumerWrapper(observer.getTopic(), new MessageListener(){

                public void onMessage(Message msg) {
                    JMSConnectionWrapper.this.gateWay.handleRequestMsg(msg, observer);
                }
            });
            this.m_observers.put(observer, consumer);
            this.registerConsumer(consumer);
        }
    }

    private void registerConsumer(JMSConsumerWrapper consumer) {
        try {
            if (this.isConnected) {
                Session ss = this.connectionImp.createSession(false, 1);
                Topic tp = ss.createTopic(consumer.getTopic());
                ss.createConsumer((Destination)tp).setMessageListener(consumer.getListener());
                consumer.setSessionImp(ss);
            }
        }
        catch (JMSException e) {
            logger.error("JMS exception in registerConsumer : consumer=" + consumer + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(IRemoteEventObserver observer) {
        Map<IRemoteEventObserver, JMSConsumerWrapper> map = this.m_observers;
        synchronized (map) {
            JMSConsumerWrapper consumer = this.m_observers.remove(observer);
            if (null == consumer) {
                return;
            }
            this.closeSession(consumer.getSessionImp());
            consumer.setSessionImp(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllConsumer() {
        Map<IRemoteEventObserver, JMSConsumerWrapper> map = this.m_observers;
        synchronized (map) {
            for (JMSConsumerWrapper consumer : this.m_observers.values()) {
                try {
                    this.closeSession(consumer.getSessionImp());
                    Session ss = this.connectionImp.createSession(false, 1);
                    Topic tp = ss.createTopic(consumer.getTopic());
                    ss.createConsumer((Destination)tp).setMessageListener(consumer.getListener());
                    consumer.setSessionImp(ss);
                }
                catch (JMSException e) {
                    logger.error("registerConsumer failed : consumer =" + consumer, (Throwable)e);
                }
            }
        }
    }

    public JMSConnectionWrapper(JMSGateway gateWay, String serverURL, TimerQueue timer) {
        this.gateWay = gateWay;
        this.timerQueue = timer;
        this.connectionfactory = new ActiveMQConnectionFactory(serverURL + "?tcpNoDelay=true");
        this.connectionfactory.setCopyMessageOnSend(false);
        this.connectionfactory.setUseAsyncSend(true);
        this.connectionfactory.setDispatchAsync(true);
        this.connectionfactory.setAlwaysSessionAsync(false);
        this.connectionfactory.setOptimizeAcknowledge(true);
    }

    private void closeSession(Session ss) {
        if (null == ss) {
            return;
        }
        try {
            ss.close();
        }
        catch (JMSException e) {
            logger.error("closeSession failed : session = " + ss + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.isConnected) {
            return;
        }
        try {
            this.connectionImp = this.connectionfactory.createConnection();
            this.connectionImp.start();
            this.connectionImp.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException ex) {
                    JMSConnectionWrapper.this.isConnected = false;
                    logger.error("JMS-connection exception : " + ex);
                    JMSConnectionWrapper.this.reConnect(0L);
                }
            });
        }
        catch (JMSException e) {
            if (null != this.connectionImp) {
                try {
                    this.connectionImp.close();
                }
                catch (JMSException e1) {
                    logger.error("close JMS-Server failed", (Throwable)e);
                }
            }
            logger.error("connect JMS-Server failed : " + (Object)((Object)e));
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.isConnected = true;
            this.registerResponse();
            this.registerAllConsumer();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void registerResponse() {
        this.m_responseTopic = UUID.randomUUID().toString();
        JMSConsumerWrapper responseConsumer = new JMSConsumerWrapper(this.m_responseTopic, new MessageListener(){

            public void onMessage(Message nativeMsg) {
                JMSConnectionWrapper.this.gateWay.handleResponseMsg(nativeMsg);
            }
        });
        this.registerConsumer(responseConsumer);
    }

    public String getResponseTopic() {
        return this.m_responseTopic;
    }

    private void reConnect(long delay) {
        this.timerQueue.scheduleTimer(new Runnable(){

            @Override
            public void run() {
                JMSConnectionWrapper.this.connect();
                if (!JMSConnectionWrapper.this.isConnected) {
                    JMSConnectionWrapper.this.reConnect(10000L);
                }
            }
        }, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block5: {
            this.lock.writeLock().lock();
            try {
                if (!this.isConnected) break block5;
                try {
                    this.connectionImp.setExceptionListener(null);
                    this.connectionImp.close();
                }
                catch (JMSException e) {
                    logger.error("close failed : " + (Object)((Object)e));
                }
                this.isConnected = false;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void sendMsg(String topic, JMSMessage msg) {
        if (!this.isConnected) {
            logger.error("send message to JMS-Server failed , m_isConnected is" + this.isConnected);
            throw new EventExcpetion(-5);
        }
        try {
            Session session = this.connectionImp.createSession(false, 1);
            Topic tp = session.createTopic(topic);
            MessageProducer publisher = session.createProducer((Destination)tp);
            publisher.setDeliveryMode(1);
            MapMessage mapMsg = session.createMapMessage();
            JMSMessageHelper.encodeProtocolMsg(msg, mapMsg);
            publisher.send((Message)mapMsg);
            session.close();
        }
        catch (JMSException e) {
            logger.error("send message to JMS-Server failed ,topic = " + topic, (Throwable)e);
            throw new EventExcpetion(-6);
        }
    }
}

