/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl;

import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventCallback;
import com.huawei.uflight.event.client.IEventListener;
import com.huawei.uflight.event.client.impl.AbstractEventManager;
import com.huawei.uflight.event.client.impl.support.Scheduler;
import com.huawei.uflight.event.process.INeProcessInfoHolder;
import com.huawei.uflight.event.process.IProcessInfoHolder;
import com.huawei.uflight.event.process.ProcessInfo;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDispatcher
extends AbstractEventManager {
    private Scheduler scheduler;
    private IProcessInfoHolder processHolder;
    private INeProcessInfoHolder neProcessAgent;
    private LocalListenersMgr listenerMgr = new LocalListenersMgr();
    private static Logger logger = LoggerFactory.getLogger(LocalDispatcher.class);

    @Override
    public int publishEvent(IEvent event) {
        List<IEventListener> list = this.getListenerList(event.getTopic());
        if (null == list) {
            if (logger.isInfoEnabled()) {
                logger.info("event is not local Listener" + event);
            }
            throw new EventExcpetion(-1);
        }
        this.publishEvent(list, event);
        return 0;
    }

    void publishEvent(final List<IEventListener> list, final IEvent event) {
        this.getScheduler().scheduleTask(new Runnable(){

            @Override
            public void run() {
                for (IEventListener listener : list) {
                    listener.processEvent(event);
                }
            }
        });
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout) {
        IEventListener listener = this.getSingleListener(ev);
        if (null == listener) {
            throw new EventExcpetion(-1);
        }
        return this.sendEvent(listener, ev, timeout);
    }

    EventResponse sendEvent(final IEventListener listener, final IEvent ev, int timeout) {
        return this.getScheduler().scheduleSyncTask(new Callable<EventResponse>(){

            @Override
            public EventResponse call() throws Exception {
                return listener.processEvent(ev);
            }
        }, timeout);
    }

    @Override
    public void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer) {
        IEventListener listener = this.getSingleListener(ev);
        if (null == listener) {
            throw new EventExcpetion(-1);
        }
        this.sendAsyncEvent(listener, ev, timeout, observer);
    }

    void sendAsyncEvent(final IEventListener listener, final IEvent ev, int timeout, IEventCallback observer) {
        this.getScheduler().scheduleTask(new Callable<EventResponse>(){

            @Override
            public EventResponse call() throws Exception {
                return listener.processEvent(ev);
            }
        }, timeout, observer);
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout, ProcessInfo processInfo) {
        IEventListener listener = this.getListernerByProcess(ev.getTopic(), processInfo);
        if (null == listener) {
            throw new EventExcpetion(-1);
        }
        return this.sendEvent(listener, ev, timeout);
    }

    @Override
    protected void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer, ProcessInfo processInfo) {
        IEventListener listener = this.getListernerByProcess(ev.getTopic(), processInfo);
        if (null == listener) {
            throw new EventExcpetion(-1);
        }
        this.sendAsyncEvent(listener, ev, timeout, observer);
    }

    IEventListener getSingleListener(IEvent ev) {
        if (ev.getNeID() > 0) {
            return this.getListener(ev.getTopic(), ev.getNeID());
        }
        List<IEventListener> listenerList = this.listenerMgr.getListener(ev.getTopic());
        if (null != listenerList && !listenerList.isEmpty() && listenerList.size() == 1) {
            return listenerList.get(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSingleListener is fail, list = " + listenerList);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("no found IEventListener , event = " + ev);
        }
        return null;
    }

    List<IEventListener> getListenerList(String topic) {
        List<IEventListener> list = this.listenerMgr.getListener(topic);
        if (null == list && logger.isDebugEnabled()) {
            logger.debug("no local Listener for topic =" + topic);
        }
        return list;
    }

    private IEventListener getListener(String topic, int neid) {
        if (null == this.getNeProcessAgent()) {
            logger.error("getNeProcessAgent is null, neid = " + neid);
            throw new EventExcpetion(-4);
        }
        List<IEventListener> list = this.listenerMgr.getListener(topic);
        if (null == list) {
            return null;
        }
        Set<ProcessInfo> localMgr = this.getNeProcessAgent().getManager(neid);
        if (localMgr.isEmpty()) {
            logger.error("no found ne ProcessInfom ,neid = " + neid);
            return null;
        }
        for (IEventListener listener : list) {
            ProcessInfo proc = this.getProcessHolder().getCurrentProcessInfo(listener.getClass());
            if (!localMgr.contains(proc)) continue;
            return listener;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("local no found IEventListener ,neid = " + neid);
        }
        return null;
    }

    IEventListener getListernerByProcess(String topic, ProcessInfo processInfo) {
        IEventListener listener = null;
        List<IEventListener> list = this.getListenerList(topic);
        if (null == list) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            listener = list.get(i);
            ProcessInfo proc = this.getProcessHolder().getCurrentProcessInfo(listener.getClass());
            if (!processInfo.equals(proc)) continue;
            return listener;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("local no found IEventListener ,processInfo = " + processInfo);
        }
        return null;
    }

    @Override
    public void addEventListener(String topic, IEventListener listener) {
        this.listenerMgr.addEventListener(topic, listener);
    }

    @Override
    public void removeEventListener(String topic, IEventListener listener) {
        this.listenerMgr.removeEventListener(topic, listener);
    }

    void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    void setProcessHolder(IProcessInfoHolder processHolder) {
        this.processHolder = processHolder;
    }

    IProcessInfoHolder getProcessHolder() {
        return this.processHolder;
    }

    void setNeProcessAgent(INeProcessInfoHolder neProcessAgent) {
        this.neProcessAgent = neProcessAgent;
    }

    INeProcessInfoHolder getNeProcessAgent() {
        return this.neProcessAgent;
    }

    @Override
    public void stop() {
        this.listenerMgr.clear();
    }

    private class LocalListenersMgr {
        private ConcurrentHashMap<String, CopyOnWriteArrayList<IEventListener>> listenerMap = new ConcurrentHashMap();

        public List<IEventListener> getListener(String topic) {
            return this.listenerMap.get(topic);
        }

        public void addEventListener(String topic, IEventListener listener) {
            CopyOnWriteArrayList<IEventListener> list;
            if (!this.listenerMap.containsKey(topic)) {
                this.listenerMap.putIfAbsent(topic, new CopyOnWriteArrayList());
            }
            if (null != (list = this.listenerMap.get(topic))) {
                list.add(listener);
            }
        }

        public void removeEventListener(String topic, IEventListener listener) {
            CopyOnWriteArrayList<IEventListener> list;
            if (this.listenerMap.containsKey(topic) && null != (list = this.listenerMap.get(topic))) {
                list.remove(listener);
            }
        }

        public void clear() {
            this.listenerMap.clear();
        }
    }
}

