/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl;

import com.huawei.uflight.event.EventConfLoadMgr;
import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventCallback;
import com.huawei.uflight.event.client.IEventListener;
import com.huawei.uflight.event.client.IEventManager;
import com.huawei.uflight.event.client.impl.AbstractEventManager;
import com.huawei.uflight.event.client.impl.DispatcherWithRemote;
import com.huawei.uflight.event.client.impl.LocalDispatcher;
import com.huawei.uflight.event.client.impl.jms.JMSGateway;
import com.huawei.uflight.event.client.impl.support.Scheduler;
import com.huawei.uflight.event.client.impl.support.TimerQueue;
import com.huawei.uflight.event.process.ProcessInfo;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EventManagerImp
extends AbstractEventManager
implements IEventManager {
    private AbstractEventManager eventDispatcher;
    private static final int THREAD_KEEPLIVE_MINUTE = 5;
    private Scheduler schedulerPool;

    public void init() {
        ScheduledThreadPoolExecutor scheduleExecutor = new ScheduledThreadPoolExecutor(5);
        scheduleExecutor.setKeepAliveTime(5L, TimeUnit.MINUTES);
        scheduleExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolExecutor sendExecutor = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        sendExecutor.allowCoreThreadTimeOut(true);
        TimerQueue timeQueue = new TimerQueue(scheduleExecutor);
        this.schedulerPool = new Scheduler(sendExecutor, timeQueue);
        LocalDispatcher localDispatcher = this.initLocalDispatcher();
        if (EventConfLoadMgr.getInstance().isWithRemoteDispatcher()) {
            String serverURL = EventConfLoadMgr.getInstance().getServerUrl();
            DispatcherWithRemote remoteDispatcher = new DispatcherWithRemote();
            remoteDispatcher.setLocalDispatcher(localDispatcher);
            remoteDispatcher.setProcessHolder(EventConfLoadMgr.getInstance().getProcessInfoHolder());
            JMSGateway jmsGate = new JMSGateway(serverURL, this.schedulerPool, timeQueue);
            jmsGate.start();
            remoteDispatcher.setJmsGate(jmsGate);
            this.eventDispatcher = remoteDispatcher;
        } else {
            this.eventDispatcher = localDispatcher;
        }
    }

    @Override
    public void stop() {
        this.eventDispatcher.stop();
        this.schedulerPool.stop();
    }

    private LocalDispatcher initLocalDispatcher() {
        LocalDispatcher localDispatcher = new LocalDispatcher();
        localDispatcher.setScheduler(this.schedulerPool);
        localDispatcher.setProcessHolder(EventConfLoadMgr.getInstance().getProcessInfoHolder());
        if (EventConfLoadMgr.getInstance().getDepolyMode() == 0) {
            localDispatcher.setNeProcessAgent(EventConfLoadMgr.getInstance().getNeProcessInfoHolder());
        }
        return localDispatcher;
    }

    @Override
    public void addEventListener(String topic, IEventListener listener) {
        this.eventDispatcher.addEventListener(topic, listener);
    }

    @Override
    public void removeEventListener(String topic, IEventListener listener) {
        this.eventDispatcher.removeEventListener(topic, listener);
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout) {
        try {
            return this.eventDispatcher.sendEvent(ev, timeout);
        }
        catch (EventExcpetion e) {
            return new EventResponse(e.getErrorCode());
        }
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout, ProcessInfo processInfo) {
        try {
            return this.eventDispatcher.sendEvent(ev, timeout, processInfo);
        }
        catch (EventExcpetion e) {
            return new EventResponse(e.getErrorCode());
        }
    }

    @Override
    protected void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer) {
        try {
            this.eventDispatcher.sendAsyncEvent(ev, timeout, observer);
        }
        catch (EventExcpetion e) {
            observer.handleResponse(new EventResponse(e.getErrorCode()));
        }
    }

    @Override
    protected void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer, ProcessInfo processInfo) {
        try {
            this.eventDispatcher.sendAsyncEvent(ev, timeout, observer, processInfo);
        }
        catch (EventExcpetion e) {
            observer.handleResponse(new EventResponse(e.getErrorCode()));
        }
    }

    @Override
    public int publishEvent(IEvent ev) {
        try {
            return this.eventDispatcher.publishEvent(ev);
        }
        catch (EventExcpetion e) {
            return e.getErrorCode();
        }
    }
}

