/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl;

import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventCallback;
import com.huawei.uflight.event.client.IEventListener;
import com.huawei.uflight.event.client.impl.AbstractEventManager;
import com.huawei.uflight.event.client.impl.LocalDispatcher;
import com.huawei.uflight.event.client.impl.RemoteEventObserverImp;
import com.huawei.uflight.event.client.impl.jms.JMSGateway;
import com.huawei.uflight.event.client.impl.jms.JMSMessageHelper;
import com.huawei.uflight.event.process.IProcessInfoHolder;
import com.huawei.uflight.event.process.ProcessInfo;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherWithRemote
extends AbstractEventManager {
    private JMSGateway jmsGate;
    private LocalDispatcher localDispatcher;
    private IProcessInfoHolder processHolder;
    private static final Logger logger = LoggerFactory.getLogger(DispatcherWithRemote.class);

    @Override
    public int publishEvent(IEvent ev) {
        List<IEventListener> localList = this.localDispatcher.getListenerList(ev.getTopic());
        if (null != localList) {
            this.localDispatcher.publishEvent(localList, ev);
        }
        this.getJmsGate().publishTopic(ev.getTopic(), JMSMessageHelper.newNotifyMsg(ev));
        return 0;
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout) {
        IEventListener listener = this.getLocalDispatcher().getSingleListener(ev);
        if (null != listener) {
            return this.getLocalDispatcher().sendEvent(listener, ev, timeout);
        }
        return this.sendEventByRemote(ev, timeout, null);
    }

    @Override
    protected EventResponse sendEvent(IEvent ev, int timeout, ProcessInfo processInfo) {
        IEventListener listener = this.getLocalDispatcher().getListernerByProcess(ev.getTopic(), processInfo);
        if (null != listener) {
            return this.getLocalDispatcher().sendEvent(listener, ev, timeout);
        }
        return this.sendEventByRemote(ev, timeout, processInfo);
    }

    private EventResponse sendEventByRemote(IEvent ev, int timeout, ProcessInfo processInfo) {
        final AtomicReference referent = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.getJmsGate().sendMsg(ev, timeout, new IEventCallback(){

            @Override
            public void handleResponse(EventResponse response) {
                referent.set(response);
                latch.countDown();
            }
        }, processInfo);
        try {
            latch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("sendEvent to Remote fail , ev = " + ev + e);
            throw new EventExcpetion(-3);
        }
        return (EventResponse)referent.get();
    }

    @Override
    protected void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer) {
        IEventListener listener = this.getLocalDispatcher().getSingleListener(ev);
        if (null != listener) {
            this.getLocalDispatcher().sendAsyncEvent(ev, timeout, observer);
            return;
        }
        this.getJmsGate().sendMsg(ev, timeout, observer, null);
    }

    @Override
    protected void sendAsyncEvent(IEvent ev, int timeout, IEventCallback observer, ProcessInfo processInfo) {
        IEventListener listener = this.getLocalDispatcher().getListernerByProcess(ev.getTopic(), processInfo);
        if (null != listener) {
            this.getLocalDispatcher().sendAsyncEvent(listener, ev, timeout, observer);
        }
        this.getJmsGate().sendMsg(ev, timeout, observer, processInfo);
    }

    @Override
    public void addEventListener(String topic, IEventListener listener) {
        if (topic == null || listener == null) {
            logger.error("addEventListener fail , topic = " + topic + " listener = " + listener);
            return;
        }
        this.localDispatcher.addEventListener(topic, listener);
        String remoteTopic = this.getRemoteTopic(topic, listener);
        RemoteEventObserverImp remoteObserver = new RemoteEventObserverImp(remoteTopic, listener);
        this.getJmsGate().registerHandler(remoteObserver);
    }

    @Override
    public void removeEventListener(String topic, IEventListener listener) {
        if (topic == null || listener == null) {
            logger.error("addEventListener fail , topic = " + topic + " listener = " + listener);
            return;
        }
        this.localDispatcher.removeEventListener(topic, listener);
        String remoteTopic = this.getRemoteTopic(topic, listener);
        RemoteEventObserverImp remoteObserver = new RemoteEventObserverImp(remoteTopic, listener);
        this.getJmsGate().removeHandler(remoteObserver);
    }

    private String getRemoteTopic(String topic, IEventListener listener) {
        ProcessInfo proc = this.getProcessHolder().getCurrentProcessInfo(listener.getClass());
        String remoteTopic = topic + '/' + proc.getProcID() + '/' + proc.getProcHandle();
        return remoteTopic;
    }

    void setLocalDispatcher(LocalDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    LocalDispatcher getLocalDispatcher() {
        return this.localDispatcher;
    }

    void setProcessHolder(IProcessInfoHolder processHolder) {
        this.processHolder = processHolder;
    }

    IProcessInfoHolder getProcessHolder() {
        return this.processHolder;
    }

    void setJmsGate(JMSGateway jmsGate) {
        this.jmsGate = jmsGate;
    }

    JMSGateway getJmsGate() {
        return this.jmsGate;
    }

    @Override
    public void stop() {
        this.localDispatcher.stop();
        this.jmsGate.stop();
    }
}

