/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event;

import com.huawei.uflight.event.process.INeProcessInfoHolder;
import com.huawei.uflight.event.process.IProcessInfoHolder;
import com.huawei.uflight.event.process.impl.DefaultNEProcessInfoHolder;
import com.huawei.uflight.event.process.impl.DefaultProcessInfoHolder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfLoadMgr {
    private static final String EVENT_SERVER_PORT = "PORT";
    private static final String EVENT_SERVER_IP = "IP";
    private static final String EVENT_PROTOCOL = "PROTOCOL";
    private static final String CONF_FILE = "/conf/EventClientConfig.cfg";
    private static EventConfLoadMgr Instance = new EventConfLoadMgr();
    private volatile IProcessInfoHolder processinfoHolder = null;
    private volatile INeProcessInfoHolder neProcessinfoHolder = null;
    private boolean isWithRemoteDispatcher = false;
    private boolean isUflightRuntime = true;
    private String serverURL = null;
    private Logger logger = LoggerFactory.getLogger(EventConfLoadMgr.class);

    public static EventConfLoadMgr getInstance() {
        return Instance;
    }

    public void start() {
        if (null != this.processinfoHolder) {
            this.processinfoHolder.start();
        }
    }

    public void stop() {
        if (null != this.processinfoHolder) {
            this.processinfoHolder.stop();
        }
    }

    public INeProcessInfoHolder getNeProcessInfoHolder() {
        if (null == this.neProcessinfoHolder) {
            this.neProcessinfoHolder = new DefaultNEProcessInfoHolder();
        }
        return this.neProcessinfoHolder;
    }

    public IProcessInfoHolder getProcessInfoHolder() {
        return this.processinfoHolder;
    }

    public void setNeProcessInfoHolder(INeProcessInfoHolder infoHolder) {
        this.neProcessinfoHolder = infoHolder;
    }

    public void setProcessInfoHolder(IProcessInfoHolder infoHolder) {
        this.processinfoHolder = infoHolder;
    }

    public String getServerUrl() {
        return this.serverURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initConf() {
        BufferedReader read = null;
        Properties prop = new Properties();
        String userPath = System.getProperty("user.dir");
        try {
            read = new BufferedReader(new FileReader(userPath + CONF_FILE));
            prop.load(read);
            this.serverURL = this.constructServerURL(prop);
            this.isWithRemoteDispatcher = Boolean.parseBoolean(prop.getProperty("is_remote_dispatcher", "false"));
            this.isUflightRuntime = Boolean.parseBoolean(prop.getProperty("is_uflight_runtime", "true"));
            if (this.isUflightRuntime) {
                this.processinfoHolder = new DefaultProcessInfoHolder();
            }
        }
        catch (Exception ex) {
            this.logger.error("getServerURL error", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != read) {
                try {
                    read.close();
                }
                catch (IOException ex) {
                    this.logger.error("initConf fail", (Throwable)ex);
                }
            }
        }
        return true;
    }

    private String constructServerURL(Properties prop) {
        String protocol = prop.getProperty(EVENT_PROTOCOL);
        String ip = prop.getProperty(EVENT_SERVER_IP);
        String port = prop.getProperty(EVENT_SERVER_PORT);
        this.checkNull(EVENT_PROTOCOL, protocol);
        this.checkNull(EVENT_SERVER_IP, ip);
        this.checkNull(EVENT_SERVER_PORT, port);
        return protocol + "://" + ip + ":" + port;
    }

    private void checkNull(String key, String obj) {
        if (null == obj) {
            throw new IllegalArgumentException(key + " is null");
        }
    }

    public boolean isWithRemoteDispatcher() {
        return this.isWithRemoteDispatcher;
    }

    public int getDepolyMode() {
        return this.processinfoHolder.getDepolyMode();
    }

    public boolean isUFlightRuntime() {
        return this.isUflightRuntime;
    }
}

