/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event;

import com.huawei.uflight.event.EventConfLoadMgr;
import com.huawei.uflight.event.client.IEventManager;
import com.huawei.uflight.event.client.impl.EventManagerImp;
import com.huawei.uflight.event.process.INeProcessInfoHolder;
import com.huawei.uflight.event.process.IProcessInfoHolder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private static BundleContext context;
    private ServiceTracker processInfoHolderTracker;
    private ServiceTracker neProcessInfoHolderTracker;
    private EventManagerImp eventManager;
    private Logger logger = LoggerFactory.getLogger(Activator.class);

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext _context) {
        context = _context;
        if (!EventConfLoadMgr.getInstance().initConf()) {
            return;
        }
        if (!EventConfLoadMgr.getInstance().isUFlightRuntime()) {
            this.processInfoHolderTracker = new ServiceTracker(context, IProcessInfoHolder.class.getName(), (ServiceTrackerCustomizer)this);
            this.processInfoHolderTracker.open();
            this.neProcessInfoHolderTracker = new ServiceTracker(context, INeProcessInfoHolder.class.getName(), (ServiceTrackerCustomizer)this);
            this.neProcessInfoHolderTracker.open();
        }
        EventConfLoadMgr.getInstance().start();
        this.eventManager = new EventManagerImp();
        this.eventManager.init();
        context.registerService(IEventManager.class.getName(), (Object)this.eventManager, null);
    }

    public void stop(BundleContext arg0) {
        if (null != this.processInfoHolderTracker) {
            this.processInfoHolderTracker.close();
            this.neProcessInfoHolderTracker.close();
        }
        EventConfLoadMgr.getInstance().stop();
        this.eventManager.stop();
        context = null;
    }

    public Object addingService(ServiceReference paramServiceReference) {
        Object service = context.getService(paramServiceReference);
        if (service instanceof IProcessInfoHolder) {
            EventConfLoadMgr.getInstance().setProcessInfoHolder((IProcessInfoHolder)service);
        } else if (service instanceof INeProcessInfoHolder) {
            EventConfLoadMgr.getInstance().setNeProcessInfoHolder((INeProcessInfoHolder)service);
        } else {
            this.logger.error("ServiceReference is undefine , service = " + service);
        }
        return service;
    }

    public void modifiedService(ServiceReference paramServiceReference, Object paramObject) {
    }

    public void removedService(ServiceReference paramServiceReference, Object paramObject) {
        context.ungetService(paramServiceReference);
    }
}

