/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.Serializer;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.DefaultNaming;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class Configuration {
    private static Properties _default;
    private static boolean bDebug;
    private static boolean bStrictElements;
    private static boolean bMarshallingValidation;
    private static XMLNaming _naming;
    private static NodeType _primitiveNodeType;

    public static boolean debug() {
        Configuration.getDefault();
        return bDebug;
    }

    public static boolean strictElements() {
        Configuration.getDefault();
        return bStrictElements;
    }

    public static boolean marshallingValidation() {
        Configuration.getDefault();
        return bMarshallingValidation;
    }

    public static synchronized Properties getDefault() {
        if (_default == null) {
            Configuration.load();
        }
        return _default;
    }

    public static String getProperty(String s, String s1) {
        return Configuration.getDefault().getProperty(s, s1);
    }

    public static synchronized XMLNaming getXMLNaming() {
        if (_naming != null) {
            return _naming;
        }
        String s = Configuration.getProperty("org.exolab.castor.xml.naming", null);
        if (s == null || s.equalsIgnoreCase("lower")) {
            _naming = new DefaultNaming();
        } else if (s.equalsIgnoreCase("mixed")) {
            DefaultNaming defaultnaming = new DefaultNaming();
            defaultnaming.setStyle((short)1);
            _naming = defaultnaming;
        } else {
            try {
                Class<?> class1 = Class.forName(s);
                _naming = (XMLNaming)class1.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to load XMLNaming: " + exception);
            }
        }
        return _naming;
    }

    public static Parser getParser() {
        return Configuration.getParser(null);
    }

    public static Parser getParser(String s) {
        Parser parser;
        String s1 = Configuration.getDefault().getProperty("org.exolab.castor.parser");
        if (s1 == null || s1.equalsIgnoreCase("xerces")) {
            s1 = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            Class<?> class1 = Class.forName(s1);
            parser = (Parser)class1.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Messages.format((String)"conf.failedInstantiateParser", (Object)s1, (Object)exception));
        }
        if (parser instanceof XMLReader) {
            String s2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.validation", "false");
            boolean flag = s2.equalsIgnoreCase("true") || s2.equalsIgnoreCase("on");
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", flag);
            }
            catch (SAXException saxexception) {
                Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)saxexception));
            }
            s2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.namespaces", "false");
            flag = s2.equalsIgnoreCase("true") || s2.equalsIgnoreCase("on");
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/namespaces", flag);
            }
            catch (SAXException saxexception1) {
                Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)saxexception1));
            }
            s = Configuration.getDefault().getProperty("org.exolab.castor.sax.features", s);
            if (s != null) {
                StringTokenizer stringtokenizer = new StringTokenizer(s, ", ");
                while (stringtokenizer.hasMoreTokens()) {
                    try {
                        ((XMLReader)((Object)parser)).setFeature(stringtokenizer.nextToken(), true);
                    }
                    catch (SAXException saxexception2) {
                        Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)saxexception2));
                    }
                }
            }
        }
        return parser;
    }

    public static synchronized NodeType getPrimitiveNodeType() {
        if (_primitiveNodeType != null) {
            return _primitiveNodeType;
        }
        String s = Configuration.getProperty("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (s == null) {
            return null;
        }
        _primitiveNodeType = NodeType.getNodeType((String)s);
        return _primitiveNodeType;
    }

    public static RegExpEvaluator getRegExpEvaluator() {
        String s = Configuration.getDefault().getProperty("org.exolab.castor.regexp");
        RegExpEvaluator regexpevaluator = null;
        if (s == null) {
            return null;
        }
        try {
            Class<?> class1 = Class.forName(s);
            regexpevaluator = (RegExpEvaluator)class1.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Messages.format((String)"conf.failedInstantiateRegExp", (Object)s, (Object)exception));
        }
        return regexpevaluator;
    }

    public static Serializer getSerializer() {
        Serializer obj;
        String s = Configuration.getDefault().getProperty("org.exolab.castor.serializer");
        if (s == null || s.equalsIgnoreCase("xerces")) {
            obj = new XMLSerializer();
        } else {
            try {
                obj = (Serializer)Class.forName(s).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(Messages.format((String)"conf.failedInstantiateSerializer", (Object)s, (Object)exception));
            }
        }
        ((Serializer)obj).setOutputFormat(Configuration.getOutputFormat());
        return obj;
    }

    public static OutputFormat getOutputFormat() {
        boolean flag = false;
        String s = Configuration.getDefault().getProperty("org.exolab.castor.indent", "");
        flag = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on");
        OutputFormat outputformat = new OutputFormat();
        outputformat.setMethod("xml");
        outputformat.setIndenting(flag);
        if (!flag) {
            outputformat.setPreserveSpace(true);
        }
        return outputformat;
    }

    public static DocumentHandler getSerializer(OutputStream outputstream) throws IOException {
        Serializer serializer = Configuration.getSerializer();
        serializer.setOutputByteStream(outputstream);
        DocumentHandler documenthandler = serializer.asDocumentHandler();
        if (documenthandler == null) {
            throw new IllegalArgumentException(Messages.format((String)"conf.serializerNotSaxCapable", (Object)serializer.getClass().getName()));
        }
        return documenthandler;
    }

    public static DocumentHandler getSerializer(Writer writer) throws IOException {
        Serializer serializer = Configuration.getSerializer();
        serializer.setOutputCharStream(writer);
        DocumentHandler documenthandler = serializer.asDocumentHandler();
        if (documenthandler == null) {
            throw new IllegalArgumentException(Messages.format((String)"conf.serializerNotSaxCapable", (Object)serializer.getClass().getName()));
        }
        return documenthandler;
    }

    protected static void load() {
        _default = Configuration.loadProperties("/org/exolab/castor/castor.properties", "castor.properties");
        String s = _default.getProperty("org.exolab.castor.debug", "");
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on")) {
            bDebug = true;
        }
        if ((s = _default.getProperty("org.exolab.castor.marshalling.validation", "")).equalsIgnoreCase("false") || s.equalsIgnoreCase("off")) {
            bMarshallingValidation = false;
        }
        bStrictElements = !(s = _default.getProperty("org.exolab.castor.xml.strictelements", "")).equalsIgnoreCase("false") && !s.equalsIgnoreCase("off");
        s = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String s, String s1) {
        Properties properties = new Properties();
        boolean flag = false;
        try {
            properties.load(Configuration.class.getResourceAsStream(s));
            flag = true;
        }
        catch (Exception exception) {
            Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)exception));
        }
        String s2 = null;
        try {
            s2 = System.getProperty("java.home");
        }
        catch (Exception exception1) {
            Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)exception1));
        }
        if (s2 != null) {
            InputStream inStream = null;
            try {
                File file = new File(s2, "lib");
                file = new File(file, s1);
                if (file.exists()) {
                    properties = new Properties(properties);
                    inStream = new FileInputStream(file);
                    properties.load(inStream);
                    flag = true;
                }
            }
            catch (IOException ioexception) {
                Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)ioexception));
            }
            finally {
                if (null != inStream) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)e));
                    }
                }
            }
        }
        try {
            InputStream inputstream = Configuration.class.getResourceAsStream("/" + s1);
            if (inputstream != null) {
                properties = new Properties(properties);
                properties.load(inputstream);
                flag = true;
            }
        }
        catch (Exception exception2) {
            Logger.getSystemLogger().println(Messages.format((String)"conf.configurationError", (Object)exception2));
        }
        if (!flag) {
            throw new IllegalArgumentException(Messages.format((String)"conf.noDefaultConfigurationFile", (Object)s1));
        }
        return properties;
    }

    static {
        bMarshallingValidation = true;
        _naming = null;
        _primitiveNodeType = null;
    }

    public static class Property {
        public static final String Serializer = "org.exolab.castor.serializer";
        public static final String PrimitiveNodeType = "org.exolab.castor.xml.introspector.primitive.nodetype";
        public static final String Parser = "org.exolab.castor.parser";
        public static final String ParserValidation = "org.exolab.castor.parser.validation";
        public static final String Namespaces = "org.exolab.castor.parser.namespaces";
        public static final String Naming = "org.exolab.castor.xml.naming";
        public static final String MarshallingValidation = "org.exolab.castor.marshalling.validation";
        public static final String Indent = "org.exolab.castor.indent";
        public static final String ParserFeatures = "org.exolab.castor.sax.features";
        public static final String ParserFeatureSeparator = ",";
        public static final String RegExp = "org.exolab.castor.regexp";
        public static final String Debug = "org.exolab.castor.debug";
        public static final String StrictElements = "org.exolab.castor.xml.strictelements";
        public static final String FileName = "castor.properties";
        static final String ResourceName = "/org/exolab/castor/castor.properties";
    }

    private static class Features {
        public static final String Validation = "http://xml.org/sax/features/validation";
        public static final String Namespaces = "http://xml.org/sax/features/namespaces";

        private Features() {
        }
    }
}

