/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public final class BinaryString
implements Comparable<BinaryString>,
Serializable {
    public static final BinaryString EMPTY = new BinaryString(0, 0, new int[0]);
    public static final BinaryString ZERO = new BinaryString(0, 0, 1);
    public static final BinaryString ONE = new BinaryString(1, 0, 1);
    private final int[] bitsContent;
    private int beginBitIndex;
    private final int bitsSize;

    private BinaryString(int begin, int capacity, int[] bits) {
        this.beginBitIndex = begin;
        this.bitsSize = capacity;
        this.bitsContent = bits;
    }

    public BinaryString(int[] bits, int beginPose, int capacity, boolean backward) {
        this.beginBitIndex = beginPose % 32;
        this.bitsSize = capacity;
        this.bitsContent = new int[(this.beginBitIndex + this.bitsSize + 31) / 32];
        if (backward) {
            int pose = (beginPose + capacity - 1) / 32;
            int i = 0;
            while (i < this.bitsContent.length) {
                this.bitsContent[i] = bits[pose];
                --pose;
                ++i;
            }
        } else {
            System.arraycopy(bits, beginPose / 32, this.bitsContent, 0, this.bitsContent.length);
        }
    }

    public BinaryString(long[] bits, int beginPose, int capacity, boolean backward) {
        this.beginBitIndex = beginPose;
        this.bitsSize = capacity;
        byte increment = (byte)(backward ? -1 : 1);
        this.bitsContent = new int[(this.beginBitIndex + this.bitsSize + 63) / 64 * 2];
        int pos = beginPose / 64;
        int i = 0;
        while (i < this.bitsContent.length) {
            this.bitsContent[i] = (int)bits[pos];
            this.bitsContent[i + 1] = (int)(bits[pos] >>> 32);
            pos += increment;
            i += 2;
        }
    }

    public BinaryString(byte[] bits, int beginPose, int capacity, boolean backward) {
        int pose;
        int limit;
        int increment;
        this.bitsSize = capacity;
        if (!backward) {
            increment = 1;
            this.beginBitIndex = beginPose % 8;
            limit = (beginPose + capacity + 7) / 8;
            pose = beginPose / 8;
        } else {
            increment = -1;
            this.beginBitIndex = (8 - (beginPose + capacity) % 8) % 8;
            limit = (beginPose - 8) / 8;
            pose = (beginPose + capacity - 1) / 8;
        }
        this.bitsContent = new int[(this.beginBitIndex + this.bitsSize + 31) / 32];
        int i = 0;
        while (pose != limit) {
            int n = i / 4;
            this.bitsContent[n] = this.bitsContent[n] | (bits[pose] & 0xFF) << 8 * (i % 4);
            pose += increment;
            ++i;
        }
    }

    public BinaryString(int value, int begin, int capacity) {
        if (begin < 0 || begin + capacity > 32) {
            throw new IllegalArgumentException("Bit indices out of range");
        }
        this.bitsContent = new int[]{value};
        this.beginBitIndex = begin;
        this.bitsSize = capacity;
    }

    public BinaryString(long value, int begin, int capacity) {
        if (begin < 0 || begin + capacity > 64) {
            throw new IllegalArgumentException("Bit indices out of range");
        }
        this.bitsContent = new int[]{(int)value, (int)(value >>> 32)};
        this.beginBitIndex = begin;
        this.bitsSize = capacity;
    }

    private final long getSubBits(int fromPos, int length) {
        if (length == 0) {
            return 0L;
        }
        int pose = (fromPos += this.beginBitIndex) / 32;
        int low = fromPos % 32;
        long rstBits = ((long)this.bitsContent[pose] & 0xFFFFFFFFL) >>> low;
        int high = 32 - low;
        while (high < length) {
            rstBits |= ((long)this.bitsContent[++pose] & 0xFFFFFFFFL) << high;
            high += 32;
        }
        if (length < 64) {
            rstBits &= (1L << length) - 1L;
        }
        return rstBits;
    }

    private final void verifyIndices(int beginIndex, int length, int max) {
        if (beginIndex < 0 || length < 0 || length > max || length > this.bitsSize) {
            throw new IllegalArgumentException("Bad index arguments");
        }
    }

    public int length() {
        return this.bitsSize;
    }

    public int convertToInt(int fromPose, int length) {
        if (fromPose + length > this.bitsSize) {
            length = this.bitsSize - fromPose;
        }
        this.verifyIndices(fromPose, length, 32);
        return (int)this.getSubBits(fromPose, length);
    }

    public long convertToLong(int fromPose, int length) {
        if (fromPose + length > this.bitsSize) {
            length = this.bitsSize - fromPose;
        }
        this.verifyIndices(fromPose, length, 64);
        return this.getSubBits(fromPose, length);
    }

    public BinaryString substring(int fromPose, int length) {
        this.verifyIndices(fromPose, length, length);
        return new BinaryString(fromPose + this.beginBitIndex, length, this.bitsContent);
    }

    public int getBitValue(int pose) {
        this.verifyIndices(pose, 1, 1);
        return (this.bitsContent[(pose += this.beginBitIndex) / 32] & 1 << pose % 32) == 0 ? 0 : 1;
    }

    public int findFirstIndexOf(int value, int fromPos) {
        this.verifyIndices(fromPos, 1, 1);
        int pose = (fromPos + this.beginBitIndex) / 32;
        int ignor = 1 << (fromPos + this.beginBitIndex) % 32;
        int index = fromPos;
        while (index < this.bitsSize) {
            if (value == 0 && (this.bitsContent[pose] & ignor) == 0 || value != 0 && (this.bitsContent[pose] & ignor) != 0) {
                return index;
            }
            if ((ignor <<= 1) == 0) {
                ignor = 1;
                ++pose;
            }
            ++index;
        }
        return -1;
    }

    public int findFirstIndexOf(int value) {
        return this.findFirstIndexOf(value, 0);
    }

    public int findLastIndexOf(int value, int fromPos) {
        this.verifyIndices(fromPos, 1, 1);
        int pose = (fromPos + this.beginBitIndex) / 32;
        int ignor = 1 << (fromPos + this.beginBitIndex) % 32;
        int index = fromPos;
        while (index >= 0) {
            if (value == 0 && (this.bitsContent[pose] & ignor) == 0 || value != 0 && (this.bitsContent[pose] & ignor) != 0) {
                return index;
            }
            if ((ignor >>>= 1) == 0) {
                ignor = Integer.MIN_VALUE;
                --pose;
            }
            --index;
        }
        return -1;
    }

    public int findLastIndexOf(int value) {
        return this.findLastIndexOf(value, this.bitsSize - 1);
    }

    public String toString() {
        if (this.bitsSize == 0) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer(this.bitsSize);
        int contentIndex = (this.beginBitIndex + this.bitsSize - 1) / 32;
        int mask = 1 << (this.beginBitIndex + this.bitsSize - 1) % 32;
        int i = 0;
        while (i < this.bitsSize) {
            strBuf.append((this.bitsContent[contentIndex] & mask) == 0 ? (char)'0' : '1');
            if ((mask >>>= 1) == 0) {
                mask = Integer.MIN_VALUE;
                --contentIndex;
            }
            ++i;
        }
        return strBuf.toString();
    }

    public int hashCode() {
        int i = 0;
        int hCode = this.bitsSize;
        while (i + 32 <= this.bitsSize) {
            hCode = hCode << 7 | (int)this.getSubBits(i, 32) | hCode >>> 25;
            i += 32;
        }
        if (i < this.bitsSize) {
            hCode |= (int)this.getSubBits(i, this.bitsSize - i);
        }
        return hCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryString)) {
            return false;
        }
        return this.compareTo((BinaryString)obj) == 0;
    }

    @Override
    public int compareTo(BinaryString bitstring) {
        int poseA = this.bitsSize;
        int poseB = bitstring.bitsSize;
        while (poseA >= 63 && poseB >= 63) {
            long diff = this.getSubBits(poseA -= 63, 63) - bitstring.getSubBits(poseB -= 63, 63);
            if (diff == 0L) continue;
            if (diff > 0L) {
                return 1;
            }
            return -1;
        }
        int len = Math.min(poseA, poseB);
        long diff = this.getSubBits(poseA - len, len) - bitstring.getSubBits(poseB - len, len);
        if (diff == 0L) {
            return this.bitsSize - bitstring.bitsSize;
        }
        if (diff > 0L) {
            return 1;
        }
        return -1;
    }

    public BinaryString andOper(BinaryString bitstring) {
        int length = Math.min(this.bitsSize, bitstring.bitsSize);
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = (int)this.getSubBits(getPose, 32) & (int)bitstring.getSubBits(getPose, 32);
            getPose += 32;
            length -= 32;
        }
        bits[index] = (int)this.getSubBits(getPose, length) & (int)bitstring.getSubBits(getPose, length);
        return new BinaryString(0, getPose + length, bits);
    }

    public BinaryString norandOper(BinaryString bitstring) {
        int length = Math.min(this.bitsSize, bitstring.bitsSize);
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = ~((int)this.getSubBits(getPose, 32)) & (int)bitstring.getSubBits(getPose, 32);
            getPose += 32;
            length -= 32;
        }
        bits[index] = ~((int)this.getSubBits(getPose, length)) & (int)bitstring.getSubBits(getPose, length);
        return new BinaryString(0, getPose + length, bits);
    }

    public BinaryString orOper(BinaryString bitstring) {
        int length = Math.min(this.bitsSize, bitstring.bitsSize);
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = (int)this.getSubBits(getPose, 32) | (int)bitstring.getSubBits(getPose, 32);
            getPose += 32;
            length -= 32;
        }
        bits[index] = (int)this.getSubBits(getPose, length) | (int)bitstring.getSubBits(getPose, length);
        return new BinaryString(0, getPose + length, bits);
    }

    public BinaryString norOper(BinaryString bitstring) {
        int length = Math.min(this.bitsSize, bitstring.bitsSize);
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = ~((int)this.getSubBits(getPose, 32)) | (int)bitstring.getSubBits(getPose, 32);
            getPose += 32;
            length -= 32;
        }
        bits[index] = ~((int)this.getSubBits(getPose, length)) | (int)bitstring.getSubBits(getPose, length);
        return new BinaryString(0, getPose + length, bits);
    }

    public BinaryString xorOper(BinaryString bitstring) {
        int length = Math.min(this.bitsSize, bitstring.bitsSize);
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = (int)this.getSubBits(getPose, 32) ^ (int)bitstring.getSubBits(getPose, 32);
            getPose += 32;
            length -= 32;
        }
        bits[index] = (int)this.getSubBits(getPose, length) ^ (int)bitstring.getSubBits(getPose, length);
        return new BinaryString(0, getPose + length, bits);
    }

    public BinaryString valueOfNot() {
        int length = this.bitsSize;
        if (length == 0) {
            return EMPTY;
        }
        int[] bits = new int[(length + 31) / 32];
        int index = 0;
        int getPose = 0;
        while (length >= 32) {
            bits[index++] = ~((int)this.getSubBits(getPose, 32));
            getPose += 32;
            length -= 32;
        }
        bits[index] = ~((int)this.getSubBits(getPose, length));
        return new BinaryString(0, getPose + length, bits);
    }

    public void writeTo(int[] bits, int length, boolean backward) {
        int index;
        int increment;
        if (this.bitsSize == 0) {
            return;
        }
        if (!backward) {
            increment = 1;
            index = length / 32;
        } else {
            increment = -1;
            index = bits.length - length / 32 - 1;
        }
        int ignor = length % 32;
        int valid = 32 - ignor;
        int getPos = 0;
        int toWritLen = this.bitsSize;
        if (toWritLen >= valid) {
            if (ignor != 0) {
                bits[index] = bits[index] & (1 << ignor) - 1 | (int)this.getSubBits(getPos, valid) << ignor;
                getPos += valid;
                toWritLen -= valid;
                index += increment;
            }
            while (toWritLen >= 32) {
                bits[index] = (int)this.getSubBits(getPos, 32);
                toWritLen -= 32;
                getPos += 32;
                index += increment;
            }
            if (toWritLen != 0) {
                bits[index] = bits[index] & ~((1 << toWritLen) - 1) | (int)this.getSubBits(getPos, toWritLen);
            }
        } else {
            bits[index] = bits[index] & ~((1 << toWritLen) - 1 << ignor) | (int)this.getSubBits(getPos, toWritLen) << ignor;
        }
    }

    public void writeTo(long[] bits, int length, boolean backward) {
        int increment;
        int index;
        if (this.bitsSize == 0) {
            return;
        }
        if (!backward) {
            index = length / 64;
            increment = 1;
        } else {
            index = bits.length - 1 - length / 64;
            increment = -1;
        }
        int ignor = length % 64;
        int valid = 64 - ignor;
        int getPos = 0;
        int toWritLen = this.bitsSize;
        if (toWritLen >= valid) {
            if (ignor != 0) {
                bits[index] = bits[index] & (1L << ignor) - 1L | this.getSubBits(getPos, valid) << ignor;
                getPos += valid;
                toWritLen -= valid;
                index += increment;
            }
            while (toWritLen >= 64) {
                bits[index] = this.getSubBits(getPos, 64);
                toWritLen -= 64;
                getPos += 64;
                index += increment;
            }
            if (toWritLen != 0) {
                bits[index] = bits[index] & ((1L << toWritLen) - 1L ^ 0xFFFFFFFFFFFFFFFFL) | this.getSubBits(getPos, toWritLen);
            }
        } else {
            bits[index] = bits[index] & ((1L << toWritLen) - 1L << ignor ^ 0xFFFFFFFFFFFFFFFFL) | this.getSubBits(getPos, toWritLen) << ignor;
        }
    }

    public void writeTo(byte[] bits, int length, boolean backward) {
        int increment;
        int index;
        if (this.bitsSize == 0) {
            return;
        }
        if (!backward) {
            index = length / 8;
            increment = 1;
        } else {
            index = bits.length - 1 - length / 8;
            increment = -1;
        }
        int ignor = length % 8;
        int valid = 8 - ignor;
        int getPos = 0;
        int toWritLen = this.bitsSize;
        if (toWritLen >= valid) {
            if (ignor != 0) {
                bits[index] = (byte)(bits[index] & (1 << ignor) - 1 | (int)this.getSubBits(getPos, valid) << ignor);
                getPos += valid;
                toWritLen -= valid;
                index += increment;
            }
            while (toWritLen >= 8) {
                if (toWritLen >= 64) {
                    long longBits = this.getSubBits(getPos, 64);
                    bits[index] = (byte)longBits;
                    bits[index += increment] = (byte)(longBits >>> 8);
                    bits[index += increment] = (byte)(longBits >>> 16);
                    bits[index += increment] = (byte)(longBits >>> 24);
                    bits[index += increment] = (byte)(longBits >>> 32);
                    bits[index += increment] = (byte)(longBits >>> 40);
                    bits[index += increment] = (byte)(longBits >>> 48);
                    bits[index += increment] = (byte)(longBits >>> 56);
                    index += increment;
                    toWritLen -= 64;
                    getPos += 64;
                    continue;
                }
                bits[index] = (byte)this.getSubBits(getPos, 8);
                toWritLen -= 8;
                getPos += 8;
                index += increment;
            }
            if (toWritLen != 0) {
                bits[index] = (byte)(bits[index] & ~((1 << toWritLen) - 1) | (int)this.getSubBits(getPos, toWritLen));
            }
        } else {
            bits[index] = (byte)(bits[index] & ~((1 << toWritLen) - 1 << ignor) | (int)this.getSubBits(getPos, toWritLen) << ignor);
        }
    }

    public BigInteger convertToBigInteger(boolean flag) {
        int i = this.bitsSize;
        byte[] bits = new byte[(i + 7) / 8 + (flag ? 1 : 0)];
        this.writeTo(bits, flag ? 1 : 0, true);
        if (!flag) {
            int mask = 32 - i % 32;
            bits[0] = (byte)(bits[0] << mask >> mask);
        }
        return new BigInteger(bits);
    }

    public BinaryString concat(BinaryString bitstring) {
        int[] bits = new int[(this.bitsSize + bitstring.bitsSize + 31) / 32];
        bitstring.writeTo(bits, 0, false);
        this.writeTo(bits, bitstring.bitsSize, false);
        return new BinaryString(0, this.bitsSize + bitstring.bitsSize, bits);
    }

    public static BinaryString concat(Vector<BinaryString> bitStrings, boolean forward) {
        return BinaryString.concat(bitStrings.toArray(new BinaryString[bitStrings.size()]), forward);
    }

    public static BinaryString concat(BinaryString[] bitstrings, boolean forward) {
        int sizeSum = 0;
        BinaryString[] binaryStringArray = bitstrings;
        int n = bitstrings.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryString bitstring = binaryStringArray[n2];
            if (bitstring != null) {
                sizeSum += bitstring.bitsSize;
            }
            ++n2;
        }
        int[] bits = new int[(sizeSum + 31) / 32];
        int offset = 0;
        int limit = forward ? bitstrings.length : -1;
        byte increment = (byte)(forward ? 1 : -1);
        int i = forward ? 0 : bitstrings.length - 1;
        while (i != limit) {
            if (bitstrings[i] != null) {
                bitstrings[i].writeTo(bits, offset, false);
                offset += bitstrings[i].bitsSize;
            }
            i += increment;
        }
        return new BinaryString(0, sizeSum, bits);
    }
}

