/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.fstru;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public final class IDType
implements FStruct,
Comparable<IDType>,
Serializable {
    private static Hashtable<IDType, IDType> INTERNED_OIDS = new Hashtable();
    private static Hashtable<String, IDType> NAMED_INTERNS = new Hashtable();
    public static final int PREFIX = -2;
    public static final int EXTENSION = 2;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    private String name;
    private int[] idArr;

    public IDType(String oidName, String strID) {
        int i = strID.length();
        int j = 0;
        int k = 0;
        int length = 0;
        char charTmp = '\u0000';
        int[] idsBuf = new int[100];
        String s2 = null;
        if (strID.charAt(j) == '{') {
            if (strID.charAt(i - 1) != '}') {
                throw new IllegalArgumentException("No terminating }");
            }
            ++j;
            --i;
        }
        k = j;
        while (true) {
            if (k < i) {
                charTmp = strID.charAt(k);
                if (charTmp == ' ' || charTmp == '\t' || charTmp == '\n' || charTmp == '\r') {
                    ++k;
                    continue;
                }
            }
            int i1 = k;
            int c1 = 88;
            if (k < i && ((charTmp = strID.charAt(k)) == '-' || charTmp >= 'a' && charTmp <= 'z' || charTmp >= 'A' && charTmp <= 'Z')) {
                while (k < i) {
                    charTmp = strID.charAt(k);
                    if (charTmp == '(' || charTmp == ',' || charTmp == '.' || charTmp == ' ' || charTmp == '\t' || charTmp == '\r' || charTmp == '\n') break;
                    ++k;
                }
                if (k <= i && charTmp == '(') {
                    ++k;
                    c1 = charTmp;
                } else {
                    if (s2 != null) {
                        throw new IllegalArgumentException("Only one ASN.1 OID prefix name allowed: " + i1);
                    }
                    s2 = strID.substring(i1, k);
                    IDType asn1oid = IDType.find(s2);
                    if (asn1oid == null) {
                        throw new IllegalArgumentException("No such ASN.1 OID name registered: " + s2);
                    }
                    int[] nArray = asn1oid.idArr;
                    int n = asn1oid.idArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        idsBuf[length++] = id;
                        ++n2;
                    }
                    c1 = 0;
                }
            }
            if (c1 != 0) {
                long l1 = 0L;
                int j1 = k;
                while (k < i && (charTmp = strID.charAt(k)) >= '0' && charTmp <= '9') {
                    ++k;
                    if ((l1 = l1 * 10L + (long)charTmp - 48L) <= Integer.MAX_VALUE) continue;
                    throw new IllegalArgumentException("Components may not exceed Integer.MAX_VALUE: pos " + k);
                }
                if (j1 == k) {
                    throw new IllegalArgumentException("Illegal ASN.1 OID format: " + k);
                }
                if (c1 == 40) {
                    if (k >= i || charTmp != ')') {
                        throw new IllegalArgumentException("Can't find closing (: pos " + j1);
                    }
                    ++k;
                }
                idsBuf[length++] = (int)l1;
            }
            while (k < i) {
                charTmp = strID.charAt(k);
                if (charTmp != ' ' && charTmp != '\t' && charTmp != '\n' && charTmp != '\r') break;
                ++k;
            }
            if (k >= i) break;
            charTmp = strID.charAt(k);
            if (charTmp != '.' && charTmp != ',') continue;
            ++k;
        }
        if (length == 0) {
            throw new IllegalArgumentException("Empty ASN.1 OID");
        }
        this.idArr = new int[length];
        System.arraycopy(idsBuf, 0, this.idArr, 0, length);
        this.name = oidName;
    }

    public IDType(String oidName, IDType asn1oid) {
        this.idArr = (int[])asn1oid.idArr.clone();
        this.name = oidName;
    }

    public IDType(String s, int[] ai) {
        this(s, ai, 0, ai.length);
    }

    public IDType(String s, IDType asn1oid, int[] ai) {
        this(s, asn1oid, ai, 0, ai.length);
    }

    public IDType(String s, IDType asn1oid, int i) {
        int j = asn1oid.idArr.length;
        this.idArr = new int[j + 1];
        System.arraycopy(asn1oid.idArr, 0, this.idArr, 0, j);
        this.idArr[j] = i;
        this.name = s;
    }

    public IDType(String oidName, IDType asn1oid, int[] src, int i, int length) {
        int lenA = asn1oid.idArr.length;
        this.idArr = new int[lenA + length];
        System.arraycopy(asn1oid.idArr, 0, this.idArr, 0, lenA);
        System.arraycopy(src, 0, this.idArr, lenA, length);
        this.name = oidName;
    }

    public IDType(String oidName, int[] src, int srcPos, int length) {
        this.idArr = new int[length];
        System.arraycopy(src, srcPos, this.idArr, 0, length);
        this.name = oidName;
    }

    public IDType() {
        this.idArr = null;
    }

    @Override
    public void deserialize(Decoder asn1decoder) throws FStruException {
        if (this.idArr != null) {
            throw new SecurityException("Initialized ASN1OID objects are immutable");
        }
        IDType asn1oid = asn1decoder.deserializeIDType();
        this.name = asn1oid.name;
        this.idArr = asn1oid.idArr;
    }

    @Override
    public void serialize(Encoder asn1encoder) throws FStruException {
        asn1encoder.serializeIDType(this);
    }

    public String name() {
        return this.name;
    }

    public int level() {
        return this.idArr.length;
    }

    public int nthComponent(int index) {
        return this.idArr[index];
    }

    @Override
    public int compareTo(IDType asn1oid) {
        int lenA = this.idArr.length;
        int lenB = asn1oid.idArr.length;
        int length = Math.min(lenA, lenB);
        int i = 0;
        while (i < length) {
            int diff = this.idArr[i] - asn1oid.idArr[i];
            if (diff != 0) {
                if (diff > 0) {
                    return 1;
                }
                return -1;
            }
            ++i;
        }
        if (lenA == lenB) {
            return 0;
        }
        return lenA >= lenB ? 2 : -2;
    }

    public boolean equals(Object anObject) {
        if (anObject == null) {
            return false;
        }
        if (anObject instanceof IDType) {
            return this.compareTo((IDType)anObject) == 0;
        }
        return anObject.equals(this);
    }

    public IDType prefix(String oidName, int length) {
        return new IDType(oidName, this.idArr, 0, length);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(this.idArr.length * 6);
        strBuf.append(Integer.toString(this.idArr[0]));
        int i = 1;
        while (i < this.idArr.length) {
            strBuf.append('.').append(Integer.toString(this.idArr[i]));
            ++i;
        }
        return strBuf.toString();
    }

    public String toPrettyString() {
        if (this.name != null) {
            return this.name;
        }
        IDType asn1oid = this.findLongestInternedPrefix();
        while (asn1oid != null) {
            if (asn1oid.name != null) {
                StringBuffer strBuf = new StringBuffer(asn1oid.name.length() + (this.idArr.length - asn1oid.idArr.length) * 6);
                strBuf.append(asn1oid.name);
                int i = asn1oid.idArr.length;
                while (i < this.idArr.length) {
                    strBuf.append('.').append(Integer.toString(this.idArr[i]));
                    ++i;
                }
                return strBuf.toString();
            }
            asn1oid = asn1oid.findLongestInternedPrefix();
        }
        return this.toString();
    }

    public String toASN1String() {
        StringBuffer strBuf = new StringBuffer(this.idArr.length * 6);
        strBuf.append("{ ");
        int[] nArray = this.idArr;
        int n = this.idArr.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            strBuf.append(Integer.toString(id)).append(' ');
            ++n2;
        }
        strBuf.append('}');
        return strBuf.toString();
    }

    private static int nextHashComp(int i, int j) {
        return i << 3 ^ j ^ i >>> 29;
    }

    public int hashCode() {
        int hash = 0;
        int[] nArray = this.idArr;
        int n = this.idArr.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            hash = IDType.nextHashComp(hash, id);
            ++n2;
        }
        return hash;
    }

    public IDType intern() {
        IDType asn1oid = INTERNED_OIDS.get(this);
        if (asn1oid != null) {
            return asn1oid;
        }
        INTERNED_OIDS.put(this, this);
        if (NAMED_INTERNS.get(this.name) == null && this.name != null) {
            NAMED_INTERNS.put(this.name, this);
        }
        return this;
    }

    public IDType internedOrIdentity() {
        IDType asn1oid = INTERNED_OIDS.get(this);
        if (asn1oid != null) {
            return asn1oid;
        }
        return this;
    }

    public static IDType find(String s) {
        return NAMED_INTERNS.get(s);
    }

    public IDType findLongestInternedPrefix() {
        PreLookupHashFake prelookuphashFake = new PreLookupHashFake();
        prelookuphashFake.ids = this.idArr;
        prelookuphashFake.validSize = this.idArr.length;
        while (prelookuphashFake.validSize > 0) {
            prelookuphashFake.hashCode = 0;
            int i = 0;
            while (i < prelookuphashFake.validSize) {
                prelookuphashFake.hashCode = IDType.nextHashComp(prelookuphashFake.hashCode, prelookuphashFake.ids[i]);
                ++i;
            }
            IDType asn1oid = INTERNED_OIDS.get(prelookuphashFake);
            if (asn1oid != null) {
                return asn1oid;
            }
            PreLookupHashFake preLookupHashFake = prelookuphashFake;
            preLookupHashFake.validSize = preLookupHashFake.validSize - 1;
        }
        return null;
    }

    public static Enumeration<IDType> enumerateInternedOIDs() {
        return INTERNED_OIDS.keys();
    }

    private static class PreLookupHashFake {
        private int hashCode;
        private int[] ids;
        private int validSize;

        private PreLookupHashFake() {
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IDType)) {
                return false;
            }
            IDType asn1oid = (IDType)obj;
            if (asn1oid.level() < this.validSize) {
                return false;
            }
            int i = 0;
            while (i < this.validSize) {
                if (this.ids[i] != asn1oid.nthComponent(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

