/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.fstru;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.commustru.fstru.Constants;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.IDType;
import net.commustru.util.BinaryString;

public class FStruDecoder
extends Decoder
implements Constants {
    private static final TimeZone GMT_TIME_ZONE = new SimpleTimeZone(0, "GMT");
    private int iOctetStringLen;
    private byte[] octetStringByteArray;
    private InputStream oInputStream;
    private DeserializeStack oCurrentStack = new DeserializeStack();
    private int iStackIndex;
    private int iStackPos;
    private int iReadOctetCount;
    private boolean bPushedBack;
    private int iImplicitTag;
    private int iTag;
    private boolean bConstructed;
    private int iValueLen;

    public FStruDecoder(InputStream inputstream) {
        this(inputstream, 32);
    }

    public FStruDecoder(InputStream inputstream, int i) {
        this.oCurrentStack.stackVal = new int[2 * i];
        this.oCurrentStack.nextStack = null;
        this.oCurrentStack.prevStack = null;
        this.initInputStream(inputstream);
    }

    public FStruDecoder(byte[] buf) {
        this(new ByteArrayInputStream(buf));
    }

    public FStruDecoder(byte[] buf, int offset, int length) {
        this(new ByteArrayInputStream(buf, offset, length));
    }

    @Override
    public String deserializeBMPString() throws FStruException {
        this.verifyNextTag(30);
        return this.deserializeString(true);
    }

    @Override
    public BinaryString deserializeBinaryString() throws FStruException {
        this.verifyNextTag(3);
        byte[] value = new byte[Math.max(this.iValueLen * 8, 0)];
        int i = this.deserializeBinaryStringContents(value, 0);
        return new BinaryString(value, 0, i, true);
    }

    /*
     * Unable to fully structure code
     */
    private int deserializeBinaryStringContents(byte[] value, int length) throws FStruException {
        block5: {
            if (this.bConstructed) ** GOTO lbl21
            from = this.iValueLen * 8 - 8 - this.readOctetFromInput();
            byteIndex = length / 8;
            byteValue = value[byteIndex];
            octetIndex = length % 8;
            while (from > 0) {
                byteValue = byteValue << 8 | this.readOctetFromInput();
                octetIndex += from > 8 ? 8 : from;
                from -= 8;
                while (octetIndex >= 8) {
                    value[byteIndex++] = (byte)(byteValue >> (octetIndex -= 8));
                }
            }
            if (octetIndex > 0) {
                value[byteIndex] = (byte)byteValue;
            }
            length = byteIndex * 8 + octetIndex;
            break block5;
lbl-1000:
            // 1 sources

            {
                if (this.bConstructed) {
                    this.pushStack(this.iTag);
                }
                length = this.deserializeBinaryStringContents(value, length);
lbl21:
                // 2 sources

                ** while (this.deserializeTagAndLength())
            }
lbl22:
            // 1 sources

            this.popStack();
        }
        return length;
    }

    @Override
    public boolean deserializeBoolean() throws FStruException {
        this.verifyNextTag(1);
        return this.readOctetFromInput() != 0;
    }

    @Override
    public int deserializeChoice(int[] ai) throws FStruException {
        return this.watchNextTag();
    }

    @Override
    public int deserializeExplicit(int nextTag) throws FStruException {
        this.verifyNextTag(nextTag);
        return this.iStackPos;
    }

    @Override
    public String deserializeGeneralString() throws FStruException {
        this.verifyNextTag(27);
        return this.deserializeString(false);
    }

    @Override
    public Calendar deserializeGeneralizedTime() throws FStruException {
        this.verifyNextTag(24);
        int timeZoneOffset = 0;
        String timeString = this.deserializeString(false);
        int second = this.pick2Digits(timeString, 12);
        int minute = this.pick2Digits(timeString, 10);
        int hourOfDay = this.pick2Digits(timeString, 8);
        int date = this.pick2Digits(timeString, 6);
        int month = this.pick2Digits(timeString, 4);
        int year = this.pick2Digits(timeString, 0) * 100 + this.pick2Digits(timeString, 2);
        int millSecond = 0;
        int index = 14;
        if (timeString.charAt(14) == '.' || timeString.charAt(14) == ',') {
            char digit = timeString.charAt(index);
            while (digit >= '0' && digit <= '9') {
                millSecond = millSecond * 10 + digit - 48;
                digit = timeString.charAt(++index);
            }
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        if (timeString.length() > index) {
            char zoneStart = timeString.charAt(index);
            if (timeString.length() == index + 1 && zoneStart == 'Z') {
                timeZoneOffset = 0;
            } else if (zoneStart == '-' || zoneStart == '+') {
                byte sign = (byte)(zoneStart == '-' ? -1 : 1);
                timeZoneOffset = this.pick2Digits(timeString, index + 1) * sign * 60 + this.pick2Digits(timeString, index + 3) * sign * 1000;
            } else {
                throw new FStruException("Confused Generalized Time: No terminal Z or time zone offset ");
            }
        }
        gregoriancalendar.set(year, month - 1, date, hourOfDay, minute, second);
        gregoriancalendar.set(14, millSecond);
        gregoriancalendar.setTimeZone(FStruDecoder.buildTimeZone(timeZoneOffset));
        return gregoriancalendar;
    }

    @Override
    public String deserializeGraphicString() throws FStruException {
        this.verifyNextTag(25);
        return this.deserializeString(false);
    }

    @Override
    public String deserializeIA5String() throws FStruException {
        this.verifyNextTag(22);
        return this.deserializeString(false);
    }

    @Override
    public BigInteger deserializeInteger() throws FStruException {
        this.verifyNextTag(2);
        byte[] value = new byte[this.iValueLen];
        int i = 0;
        while (i < this.iValueLen) {
            value[i] = (byte)this.readOctetFromInput();
            ++i;
        }
        return new BigInteger(value);
    }

    @Override
    public int deserializeEnumeration() throws FStruException {
        this.verifyNextTag(10);
        int value = 0;
        int i = this.iValueLen;
        while (i > 0) {
            value = (value << 8) + this.readOctetFromInput();
            --i;
        }
        int mask = 32 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    @Override
    public int deserializeIntegerAsInt() throws FStruException {
        this.verifyNextTag(2);
        int value = 0;
        int i = this.iValueLen;
        while (i > 0) {
            value = (value << 8) + this.readOctetFromInput();
            --i;
        }
        int mask = 32 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    @Override
    public long deserializeIntegerAsLong() throws FStruException {
        this.verifyNextTag(2);
        long value = 0L;
        int i = this.iValueLen;
        while (i > 0) {
            value = (value << 8) + (long)this.readOctetFromInput();
            --i;
        }
        int mask = 64 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    @Override
    public void deserializeNull() throws FStruException {
        this.verifyNextTag(5);
        int i = this.iValueLen;
        while (i > 0) {
            this.readOctetFromInput();
            --i;
        }
    }

    @Override
    public String deserializeNumericString() throws FStruException {
        this.verifyNextTag(18);
        return this.deserializeString(false);
    }

    @Override
    public IDType deserializeIDType() throws FStruException {
        this.verifyNextTag(6);
        int byteValue = this.readOctetFromInput();
        int[] ids = new int[64];
        ids[0] = byteValue / 40;
        ids[1] = byteValue % 40;
        int length = 2;
        int idComponent = 0;
        int i = 1;
        while (i < this.iValueLen) {
            byteValue = this.readOctetFromInput();
            if (idComponent >= 0x10000000) {
                this.throwFStruException("ID Component doesn't fit into an int type");
            }
            idComponent = (idComponent << 7) + (byteValue & 0x7F);
            if ((byteValue & 0x80) == 0) {
                if (length >= ids.length) {
                    this.throwFStruException("Object identifier has more than " + ids.length + " components");
                }
                ids[length++] = idComponent;
                idComponent = 0;
            }
            ++i;
        }
        return new IDType(null, ids, 0, length);
    }

    @Override
    public byte[] deserializeOctetString() throws FStruException {
        this.verifyNextTag(4);
        this.iOctetStringLen = 0;
        this.octetStringByteArray = new byte[Math.max(0, this.iValueLen)];
        this.deserializeOctetStringContents();
        if (this.iOctetStringLen != this.octetStringByteArray.length) {
            byte[] value = new byte[this.iOctetStringLen];
            System.arraycopy(this.octetStringByteArray, 0, value, 0, this.iOctetStringLen);
            return value;
        }
        return this.octetStringByteArray;
    }

    @Override
    public int deserializeOctetString(byte[] value, int length) throws FStruException {
        this.verifyNextTag(4);
        this.iOctetStringLen = length;
        this.octetStringByteArray = value;
        this.deserializeOctetStringContents();
        if (value == this.octetStringByteArray) {
            return this.iOctetStringLen;
        }
        throw new ArrayIndexOutOfBoundsException("Byte array too small to hold ASN.1 octet string");
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void deserializeOctetStringContents() throws FStruException {
        block4: {
            if (this.bConstructed) ** GOTO lbl16
            if (this.iOctetStringLen + this.iValueLen > this.octetStringByteArray.length) {
                value = new byte[this.iOctetStringLen + this.iValueLen];
                if (this.iOctetStringLen > 0) {
                    System.arraycopy(this.octetStringByteArray, 0, value, 0, this.iOctetStringLen);
                }
                this.octetStringByteArray = value;
            }
            i = this.iValueLen;
            while (i > 0) {
                this.octetStringByteArray[this.iOctetStringLen++] = (byte)this.readOctetFromInput();
                --i;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.deserializeOctetStringContents();
                if (!this.bConstructed) continue;
                this.pushStack(this.iTag);
lbl16:
                // 3 sources

                ** while (this.deserializeTagAndLength())
            }
lbl17:
            // 1 sources

            this.popStack();
        }
    }

    @Override
    public String deserializePrintableString() throws FStruException {
        this.verifyNextTag(19);
        return this.deserializeString(false);
    }

    @Override
    public double deserializeDouble() throws FStruException {
        throw new FStruException("Double type deserializing not yet implemented");
    }

    @Override
    public int deserializeSequence() throws FStruException {
        this.verifyNextTag(16);
        return this.iStackPos;
    }

    @Override
    public int deserializeSequenceOf() throws FStruException {
        return this.deserializeSequence();
    }

    @Override
    public int deserializeSet() throws FStruException {
        this.verifyNextTag(17);
        return this.iStackPos;
    }

    @Override
    public int deserializeSetOf() throws FStruException {
        return this.deserializeSet();
    }

    @Override
    public Calendar deserializeUTCTime() throws FStruException {
        this.verifyNextTag(23);
        int timeZoneOffset = 0;
        String timeString = this.deserializeString(false);
        int second = 0;
        int minute = this.pick2Digits(timeString, 8);
        int hourOfDay = this.pick2Digits(timeString, 6);
        int dayOfMonth = this.pick2Digits(timeString, 4);
        int month = this.pick2Digits(timeString, 2);
        int year = this.pick2Digits(timeString, 0);
        year = year < 50 ? 2000 + year : 1900 + year;
        int charIndex = 10;
        char charVal = timeString.charAt(charIndex);
        if (charVal >= '0' && charVal <= '9') {
            second = this.pick2Digits(timeString, charIndex);
            charIndex = 12;
        }
        if ((charVal = timeString.charAt(charIndex)) == '+' || charVal == '-') {
            byte sign = (byte)(charVal == '-' ? -1 : 1);
            timeZoneOffset = this.pick2Digits(timeString, charIndex + 1) * sign * 60 + this.pick2Digits(timeString, charIndex + 3) * sign * 1000;
        } else if (charVal == 'Z') {
            timeZoneOffset = 0;
        } else {
            this.throwFStruException("Confused UTC Time: No terminal Z or time zone offset");
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar(year, month - 1, dayOfMonth, hourOfDay, minute, second);
        gregoriancalendar.setTimeZone(FStruDecoder.buildTimeZone(timeZoneOffset));
        return gregoriancalendar;
    }

    @Override
    public String deserializeT61String() throws FStruException {
        this.verifyNextTag(20);
        return this.deserializeString(false);
    }

    @Override
    public String deserializeVideotexString() throws FStruException {
        this.verifyNextTag(21);
        return this.deserializeString(false);
    }

    @Override
    public String deserializeVisibleString() throws FStruException {
        this.verifyNextTag(26);
        return this.deserializeString(false);
    }

    @Override
    public String deserializeTeletexString() throws FStruException {
        return this.deserializeT61String();
    }

    @Override
    public String deserializeISO646String() throws FStruException {
        return this.deserializeT61String();
    }

    @Override
    public boolean finishedBy(int i) throws FStruException {
        if (i != this.iStackPos) {
            this.throwFStruException("Unexpected termination of constructed encodings");
        }
        if (!this.deserializeTagAndLength()) {
            this.popStack();
            return true;
        }
        this.setPushBackState();
        return false;
    }

    @Override
    public int watchNextTag() throws FStruException {
        if (this.deserializeTagAndLength()) {
            this.setPushBackState();
            return this.iTag;
        }
        return 0;
    }

    @Override
    public int watchNextValueLength() throws FStruException {
        if (this.bPushedBack) {
            return this.iValueLen;
        }
        if (this.deserializeTagAndLength()) {
            this.setPushBackState();
            return this.iValueLen;
        }
        return -1;
    }

    private String deserializeString(boolean bmpStr) throws FStruException {
        StringBuffer stringbuffer = this.iValueLen > 0 ? new StringBuffer(this.iValueLen / (bmpStr ? 2 : 1)) : new StringBuffer();
        this.deserializeStringContents(stringbuffer, bmpStr);
        return stringbuffer.toString();
    }

    private void deserializeStringContents(StringBuffer stringbuffer, boolean bmpStr) throws FStruException {
        if (this.bConstructed) {
            while (this.deserializeTagAndLength()) {
                this.deserializeStringContents(stringbuffer, bmpStr);
                if (!this.bConstructed) continue;
                this.pushStack(this.iTag);
            }
            this.popStack();
        } else if (bmpStr) {
            int i = this.iValueLen;
            while (i >= 2) {
                stringbuffer.append((char)(this.readOctetFromInput() << 8 | this.readOctetFromInput() & 0xFF));
                i -= 2;
            }
            if (i > 0) {
                this.readOctetFromInput();
                return;
            }
        } else {
            int i = this.iValueLen;
            while (i > 0) {
                stringbuffer.append((char)this.readOctetFromInput());
                --i;
            }
        }
    }

    private void verifyNextTag(int nextTag) throws FStruException {
        if (!this.deserializeTagAndLength()) {
            this.throwFStruException("Should has one more tag, but none");
        }
        if (this.iImplicitTag != 0) {
            if (this.iImplicitTag != this.iTag) {
                this.throwFStruException("Read a tag: " + FStruDecoder.tag2String(this.iTag) + ", but should be (implicit): " + FStruDecoder.tag2String(this.iImplicitTag) + " / original data tag " + FStruDecoder.tag2String(nextTag));
            }
        } else if (this.iTag != nextTag) {
            this.throwFStruException("Read a tag: " + FStruDecoder.tag2String(this.iTag) + " but should be: " + FStruDecoder.tag2String(nextTag));
        }
        if (!this.bConstructed || FStruDecoder.findTagClass(nextTag) == 0 && !FStruDecoder.assertUniversalStringTag(nextTag)) {
            this.iImplicitTag = 0;
        }
        if (this.bConstructed) {
            this.pushStack(nextTag);
        }
    }

    private boolean deserializeTagAndLength() throws FStruException {
        if (this.bPushedBack) {
            this.bPushedBack = false;
            return true;
        }
        if (this.iTag == 0) {
            return false;
        }
        int i = this.oCurrentStack.stackVal[this.iStackIndex];
        if (i >= 0 && this.iReadOctetCount >= i) {
            return false;
        }
        int octet = this.readOctetFromInput();
        this.bConstructed = (octet & 0x20) != 0;
        int tagClass = 0;
        switch (octet & 0xC0) {
            case 0: {
                tagClass = 0;
                break;
            }
            case 64: {
                tagClass = 1;
                break;
            }
            case 128: {
                tagClass = 2;
                break;
            }
            case 192: {
                tagClass = 3;
            }
        }
        this.iTag = octet & 0x1F;
        if (this.iTag == 31) {
            int tagLength;
            long tagNumber = 0L;
            do {
                if ((tagNumber = (tagNumber << 7) + (long)((tagLength = this.readOctetFromInput()) & 0x7F)) <= 0x3FFFFFFFL) continue;
                this.throwFStruException("Tag number not valid");
            } while ((tagLength & 0x80) != 0);
            this.iTag = (int)tagNumber;
        }
        this.iTag = FStruDecoder.buildTag(tagClass, this.iTag);
        this.iValueLen = this.readOctetFromInput();
        if (this.iValueLen >= 128) {
            if (this.iValueLen == 128) {
                this.iValueLen = -1;
                return true;
            }
            long length = 0L;
            int lenComponentCount = this.iValueLen & 0x7F;
            while (lenComponentCount > 0) {
                int lenComponent = this.readOctetFromInput();
                if ((length = length << 8 | (long)lenComponent) >= 0x80000000L) {
                    this.throwFStruException("Length value too big");
                }
                --lenComponentCount;
            }
            this.iValueLen = (int)length;
        }
        return this.iTag != 0;
    }

    private final int pick2Digits(String timeStr, int from) throws FStruException {
        char firstDigit = '\u0000';
        char secondDigit = '\u0000';
        if (from + 1 < timeStr.length()) {
            firstDigit = timeStr.charAt(from);
            secondDigit = timeStr.charAt(from + 1);
            if (firstDigit < '0' || firstDigit > '9' || secondDigit < '0' || secondDigit > '9') {
                this.throwFStruException("Confused time: should be digits but: " + firstDigit + secondDigit);
            }
        }
        return (firstDigit - 48) * 10 + (secondDigit - 48);
    }

    private int readOctetFromInput() throws FStruException {
        try {
            int octet = this.oInputStream.read();
            if (octet < 0) {
                throw new FStruException(new EOFException("The end of input data is unexpected"));
            }
            ++this.iReadOctetCount;
            return octet;
        }
        catch (IOException ioexception) {
            throw new FStruException(ioexception);
        }
    }

    private static TimeZone buildTimeZone(int rawOffset) {
        TimeZone timeZone = null;
        String[] ids = TimeZone.getAvailableIDs(rawOffset);
        if (ids == null || ids.length == 0 || !(timeZone = TimeZone.getTimeZone(ids[0])).getID().equals(ids[0])) {
            timeZone = rawOffset == 0 ? GMT_TIME_ZONE : new SimpleTimeZone(rawOffset, "???");
        }
        return timeZone;
    }

    @Override
    public boolean isNextDefault(int tag) throws FStruException {
        return tag != this.watchNextTag();
    }

    @Override
    public void setNextImplicit(int tag) {
        this.iImplicitTag = tag;
    }

    @Override
    public boolean isNextOptional(int tag) throws FStruException {
        return this.isNextDefault(tag);
    }

    private void popStack() throws FStruException {
        int i = this.oCurrentStack.stackVal[this.iStackIndex];
        if (i < 0 && this.iTag != 0) {
            this.throwFStruException("Contents octets not used up");
        }
        if (i >= 0 && i != this.iReadOctetCount) {
            this.throwFStruException("Contents octets not used up");
        }
        if ((this.iStackIndex -= 2) < 0) {
            this.oCurrentStack = this.oCurrentStack.prevStack;
            this.iStackIndex = this.oCurrentStack.stackVal.length - 2;
        }
        this.iTag = -1;
        --this.iStackPos;
    }

    private void pushStack(int tag) {
        this.iStackIndex += 2;
        if (this.iStackIndex >= this.oCurrentStack.stackVal.length) {
            if (this.oCurrentStack.nextStack == null) {
                DeserializeStack nextDecodeStack = new DeserializeStack();
                this.oCurrentStack.nextStack = nextDecodeStack;
                nextDecodeStack.prevStack = this.oCurrentStack;
                nextDecodeStack.stackVal = new int[this.oCurrentStack.stackVal.length];
            }
            this.oCurrentStack = this.oCurrentStack.nextStack;
            this.iStackIndex = 0;
        }
        ((DeserializeStack)this.oCurrentStack).stackVal[this.iStackIndex] = this.iValueLen >= 0 ? this.iReadOctetCount + this.iValueLen : -1;
        ((DeserializeStack)this.oCurrentStack).stackVal[this.iStackIndex + 1] = tag;
        ++this.iStackPos;
    }

    private final void setPushBackState() {
        this.bPushedBack = true;
    }

    private void initInputStream(InputStream inputstream) {
        this.oInputStream = inputstream;
        this.bPushedBack = false;
        this.iReadOctetCount = 0;
        while (this.oCurrentStack.prevStack != null) {
            this.oCurrentStack = this.oCurrentStack.prevStack;
        }
        ((DeserializeStack)this.oCurrentStack).stackVal[0] = -1;
        ((DeserializeStack)this.oCurrentStack).stackVal[1] = 16;
        this.iStackPos = 0;
        this.iStackIndex = 0;
        this.iTag = 16;
        this.iImplicitTag = 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void passOverNext() throws FStruException {
        block7: {
            block6: {
                if (!this.deserializeTagAndLength()) {
                    this.throwFStruException("It is the end of (nested) encodings: can't skip next element");
                }
                if (this.iValueLen < 0) break block6;
                i = this.iValueLen;
                while (i > 0) {
                    this.readOctetFromInput();
                    --i;
                }
                break block7;
            }
            this.pushStack(this.iTag);
            ** GOTO lbl25
            {
                if (this.iValueLen < 0) {
                    this.pushStack(this.iTag);
                }
                i = this.iValueLen;
                while (i > 0) {
                    this.readOctetFromInput();
                    --i;
                }
                do {
                    if (this.deserializeTagAndLength()) continue block1;
                    this.popStack();
lbl25:
                    // 2 sources

                } while (this.iStackPos > 0);
            }
        }
    }

    private void throwFStruException(String s) throws FStruException {
        throw new FStruException(String.valueOf(s) + " (offset " + this.iReadOctetCount + ")");
    }

    private static final class DeserializeStack {
        private int[] stackVal;
        private DeserializeStack prevStack;
        private DeserializeStack nextStack;

        private DeserializeStack() {
        }
    }
}

