/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.threadpool;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPool
implements Executor {
    private static final int CORE_THREAD_COUNT = 8;
    private static final int MAX_THREAD_COUNT = 64;
    private static final long IDLE_ALIVE_TIME = 300L;
    private static final ThreadPool INSTANCE = new ThreadPool();
    private ThreadPoolExecutor executor;
    private static final Logger logger = LoggerFactory.getLogger(ThreadPool.class);

    private ThreadPool() {
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.info(String.format("rejected Thread %s : ", r));
                r.run();
            }
        };
        this.executor = new ThreadPoolExecutor(8, 64, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), handler);
        Runtime.getRuntime().addShutdownHook(new Thread("Thread pool shut down hook"){

            public void run() {
                ThreadPool.this.executor.shutdown();
            }
        });
    }

    public static ThreadPool getInstance() {
        return INSTANCE;
    }

    public void execute(Runnable event) {
        if (this.executor.isShutdown()) {
            event.run();
        } else {
            this.executor.execute(event);
        }
    }
}

