/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.threadpool;

import com.huawei.communicate.util.threadpool.TaskContainer;
import com.huawei.communicate.util.threadpool.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentInvoker
extends TaskContainer {
    private Lock lock = new Lock();
    private volatile int finishCounter;
    protected static final Logger logger = LoggerFactory.getLogger(ConcurrentInvoker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadPool pool = ThreadPool.getInstance();
        this.finishCounter = 0;
        int total = this.size();
        for (int i = 0; i < total; ++i) {
            Runnable r = this.get(i);
            pool.execute(new Invoker(r));
        }
        try {
            Lock i = this.lock;
            synchronized (i) {
                while (this.finishCounter < total) {
                    this.lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Lock {
        private Lock() {
        }
    }

    private class Invoker
    implements Runnable {
        private Runnable r;

        Invoker(Runnable r) {
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.r.run();
            }
            catch (Exception e) {
                logger.error("Reliable Event Invoker Fail.", (Throwable)e);
            }
            finally {
                Lock lock = ConcurrentInvoker.this.lock;
                synchronized (lock) {
                    ConcurrentInvoker.this.finishCounter++;
                    ConcurrentInvoker.this.lock.notifyAll();
                }
            }
        }
    }
}

