/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 7214434983321214663L;
    public static final int ALLOW_MULTI_KEY_AND_VALUE = 0;
    public static final int ALLOW_MULTI_VALUE = 1;
    public static final int ALLOW_MULTI_KEY = 2;
    private List<V> valueLst = new ArrayList<V>();
    private List<K> keys = new ArrayList<K>();
    private int iSize = 0;
    private int mode = 0;

    public SuperMap() {
        this(0);
    }

    public SuperMap(int mode) {
        this.setMode(mode);
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode error,mode=" + mode);
            }
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public int size() {
        return this.iSize;
    }

    @Override
    public void clear() {
        this.iSize = 0;
        this.valueLst.clear();
        this.keys.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.iSize == 0 || this.valueLst.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    public boolean containsKeyByValue(K key, V value) {
        return this.getKeysByValue(value).contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueLst.contains(value);
    }

    public boolean containsValueByKey(V value, K key) {
        return this.getValuesByKey(key).contains(value);
    }

    @Override
    public Collection<V> values() {
        return this.valueLst;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        if (t == null) {
            return;
        }
        Iterator<K> keysIterator = t.keySet().iterator();
        while (keysIterator.hasNext()) {
            this.put(keysIterator.next(), t.get(keysIterator.next()));
        }
    }

    public void putAll(List<K> addKeys, List<V> addValues) {
        if (addKeys == null || addValues == null || addValues.size() != addKeys.size()) {
            throw new IllegalArgumentException("\u00b2\u00bb\u00c6\u00a5\u00c5\u00e4\u00b5\u00c4\u00bc\u00fc\u00d6\u00b5\u00b3\u00a4\u00b6\u00c8!");
        }
        for (int i = 0; i < addKeys.size(); ++i) {
            this.put(addKeys.get(i), addValues.get(i));
        }
    }

    @Override
    public Set entrySet() {
        return null;
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.valueLst.get(index);
    }

    public List<V> getValuesByKey(Object key) {
        if (key == null) {
            return new ArrayList();
        }
        ArrayList<V> selectedValues = new ArrayList<V>();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).equals(key)) continue;
            selectedValues.add(this.valueLst.get(i));
        }
        return selectedValues;
    }

    public List<K> getKeysByValue(V value) {
        if (value == null) {
            return new ArrayList();
        }
        ArrayList<K> selectedKeys = new ArrayList<K>();
        for (int i = 0; i < this.valueLst.size(); ++i) {
            if (!this.valueLst.get(i).equals(value)) continue;
            selectedKeys.add(this.keys.get(i));
        }
        return selectedKeys;
    }

    @Override
    public V remove(Object key) {
        V removedValue = this.get(key);
        if (removedValue != null) {
            this.keys.remove(key);
            this.valueLst.remove(removedValue);
            this.iSize = this.keys.size();
        }
        return removedValue;
    }

    public V remove(Object key, Object value) {
        V removedValue = this.get(key);
        if (this.valueLst.remove(value)) {
            this.keys.remove(key);
            this.iSize = this.keys.size();
        }
        return removedValue;
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.get(key);
        boolean isContains = false;
        switch (this.getMode()) {
            case 0: {
                isContains = false;
                break;
            }
            case 1: {
                isContains = this.containsKey(key);
                break;
            }
            case 2: {
                isContains = this.containsValue(value);
                break;
            }
        }
        if (isContains) {
            return oldValue;
        }
        this.keys.add(key);
        this.valueLst.add(value);
        this.iSize = this.keys.size();
        return oldValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SuperMap map = (SuperMap)obj;
        return this.isSame(this.keySet(), map.keySet()) && this.isSame(this.values(), map.values());
    }

    private boolean isSame(Collection one, Collection anther) {
        if (one == null || anther == null) {
            return false;
        }
        int size = one.size();
        Object[] oneArray = one.toArray();
        Object[] antherArray = anther.toArray();
        for (int i = 0; i < size; ++i) {
            if (oneArray[i] != null && antherArray[i] != null && oneArray[i].equals(antherArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + ((Object)this.keys).hashCode() + ((Object)this.valueLst).hashCode();
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("[");
        for (int i = 0; i < this.iSize; ++i) {
            tmp.append(this.keys.get(i));
            tmp.append('=');
            tmp.append(this.valueLst.get(i));
            if (i == this.iSize - 1) continue;
            tmp.append(',');
        }
        tmp.append(']');
        return tmp.toString();
    }
}

