/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.ref;

import com.huawei.communicate.util.ref.ICleanable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Timer;
import java.util.TimerTask;

public final class WeakReferenceUtil {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static final long POLL_INTERVAL = 1000L;

    private static void startPollTimer() {
        Timer t = new Timer("WeakReferenceUtil:WeakReference collector", true);
        t.schedule(new TimerTask(){

            public void run() {
                WeakReferenceUtil.poll();
            }
        }, 1000L, 1000L);
    }

    private static synchronized void poll() {
        Reference o;
        if (null == queue) {
            queue = new ReferenceQueue();
        }
        while ((o = queue.poll()) != null) {
            if (!(o instanceof ICleanable)) continue;
            ICleanable weak = (ICleanable)((Object)o);
            weak.clean();
        }
    }

    private WeakReferenceUtil() {
    }

    public static ReferenceQueue getQueue() {
        return queue;
    }

    static {
        WeakReferenceUtil.startPollTimer();
    }
}

