/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.receive;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.receive.IReceiverReference;
import com.huawei.communicate.util.ref.ICleanable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WeakReceiverReference
extends WeakReference
implements MSGListener,
IReceiverReference,
ICleanable {
    private static Logger logger = LoggerFactory.getLogger(WeakReceiverReference.class);
    private int cmdCode;
    private CommService commService;
    private int iHashCode;

    WeakReceiverReference(ReferenceQueue q, CommService commService, int cmdCode, ILiteReceiver receiver) {
        super(receiver, q);
        this.commService = commService;
        this.cmdCode = cmdCode;
        this.iHashCode = receiver.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WeakReceiverReference) {
            Object thatReceiver;
            WeakReceiverReference that = (WeakReceiverReference)o;
            if (this.iHashCode != that.iHashCode) {
                return false;
            }
            Object myReceiver = this.get();
            if (myReceiver == (thatReceiver = that.get())) {
                return true;
            }
            if (myReceiver == null || thatReceiver == null) {
                return false;
            }
            return myReceiver.equals(thatReceiver);
        }
        return false;
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public void unregister() {
        boolean shouldRemove = true;
        if (this.commService instanceof CommHandle) {
            boolean bl = shouldRemove = !((CommHandle)this.commService).isClosed();
        }
        if (shouldRemove) {
            this.commService.removeMessageListener(this.cmdCode, this);
        }
    }

    public boolean receiveMessage(MSGPacketExt packet) {
        Object reference = this.get();
        if (packet != null && reference != null) {
            if (logger.isInfoEnabled()) {
                logger.info("receiveMessage(packet):" + packet);
            }
            ILiteReceiver receiver = (ILiteReceiver)reference;
            return receiver.receiveMessage(packet);
        }
        if (logger.isInfoEnabled()) {
            logger.info("receiveMessage(packet):Null, packet is " + packet + ", reference is " + reference);
        }
        return true;
    }

    public void timeout(int cmdCode, Character cmdHandle) {
        Object reference = this.get();
        if (reference != null) {
            ILiteReceiver receiver = (ILiteReceiver)reference;
            receiver.timeout(cmdCode, cmdHandle);
        }
    }

    public void clean() {
        this.unregister();
    }
}

