/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.receive;

import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLiteReceiver
implements ILiteReceiver {
    private static Logger logger = LoggerFactory.getLogger(AbstractLiteReceiver.class);
    private List<MSGPacketExt> cache = new LinkedList<MSGPacketExt>();
    private Runnable dispatcher = new Runnable(){

        public void run() {
            AbstractLiteReceiver.this.dispatchPackets();
        }
    };
    private volatile boolean dispatching;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInThreadPool(MSGPacketExt packet) {
        List<MSGPacketExt> list = this.cache;
        synchronized (list) {
            this.cache.add(packet);
            if (!this.dispatching) {
                this.dispatching = true;
                ThreadPool.getInstance().execute(this.dispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchPackets() {
        List<MSGPacketExt> list;
        boolean notFinish = true;
        try {
            while (true) {
                MSGPacketExt packet;
                list = this.cache;
                synchronized (list) {
                    packet = (MSGPacketExt)((LinkedList)this.cache).removeFirst();
                }
                try {
                    this.processMessage(packet);
                }
                catch (Exception ex) {
                    logger.error("error occured when processMessage", (Throwable)ex);
                }
                list = this.cache;
                synchronized (list) {
                    if (this.cache.isEmpty()) {
                        notFinish = false;
                        this.dispatching = false;
                        return;
                    }
                }
            }
        }
        finally {
            if (notFinish) {
                list = this.cache;
                synchronized (list) {
                    this.dispatching = false;
                }
            }
        }
    }

    protected abstract void processMessage(MSGPacketExt var1);

    public void timeout(int cmdCode, Character cmdHandle) {
    }

    public final boolean receiveMessage(MSGPacketExt packet) {
        if (packet != null) {
            if (logger.isDebugEnabled()) {
                MSGHead h = packet.mheader;
                String debugMsg = "cmdCode = " + h.cmdCode + " senderProcID = " + h.senderProcID + " senderProcHandle = " + h.senderProcHandle;
                logger.debug("receiveMessage(packet)", (Object)debugMsg);
            }
            if (AbstractLiteReceiver.isValidPacket(packet)) {
                this.processInThreadPool(packet);
                return this.isFinish(packet);
            }
            return false;
        }
        if (logger.isInfoEnabled()) {
            logger.info("receiveMessage(packet)", (Object)"Null, packet is null");
        }
        return true;
    }

    private static boolean isValidPacket(MSGPacketExt packet) {
        char errorCode = packet.mheader.errCode;
        if (errorCode == '\u0003' || errorCode == '\u0004') {
            if (logger.isInfoEnabled()) {
                logger.info("isValidPacket(packet)", (Object)("Invalid msg with errCode " + errorCode));
            }
            return false;
        }
        return true;
    }

    protected boolean isDispatchInvalidPacket() {
        return false;
    }

    protected boolean isFinish(MSGPacketExt packet) {
        return CommUtil.isLastPacket(packet);
    }
}

