/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.util.asn;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.util.asn.FStruDecoderFixUTC;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruEncoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsnCoder {
    private static Logger logger = LoggerFactory.getLogger(AsnCoder.class);
    public static final int DECODE_ERROR = 1090646026;

    private AsnCoder() {
    }

    public static boolean deserialize(MSGPacketExt msg, FStruct data) {
        if (msg == null || data == null) {
            logger.info("deserialize() Input param is null!");
            return false;
        }
        return AsnCoder.deserialize(msg.getData(), data);
    }

    public static boolean deserialize(byte[] bytes, FStruct data) {
        try {
            if (bytes != null && bytes.length != 0) {
                FStruDecoderFixUTC dec = new FStruDecoderFixUTC(bytes);
                data.deserialize((Decoder)dec);
                return true;
            }
            logger.info("deserialize() Fail,Return null!");
        }
        catch (FStruException e) {
            logger.error("deserialize() Fail,ASN1 deserialize Exception", (Throwable)e);
        }
        return false;
    }

    public static byte[] serialize(FStruct data) throws FStruException {
        FStruEncoder serializer = new FStruEncoder();
        data.serialize((Encoder)serializer);
        serializer.finish();
        return serializer.toByteArray();
    }

    public static FStruct asnClone(FStruct asnType) {
        FStruct dReq = null;
        try {
            dReq = (FStruct)asnType.getClass().newInstance();
        }
        catch (Exception e) {
            logger.error("asnClone", (Throwable)e);
            return null;
        }
        try {
            FStruEncoder enc = new FStruEncoder();
            asnType.serialize((Encoder)enc);
            FStruDecoderFixUTC dec = new FStruDecoderFixUTC(enc.toByteArray());
            dReq.deserialize((Decoder)dec);
        }
        catch (FStruException e) {
            logger.error("asnClone", (Throwable)e);
        }
        return dReq;
    }

    public static int deserializeIfOK(int sendState, MSGSyncReceiver receiver, FStruct response) {
        MSGPacketExt msgPkt;
        if (0 == sendState && !AsnCoder.deserialize(msgPkt = receiver.getResult(), response)) {
            return 1090646026;
        }
        return sendState;
    }
}

