/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.IPkgSplitter;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.multipkg.impl.DefaultPkgSplitter;
import com.huawei.communicate.multipkg.impl.MultiPkgCommHandleFactory;
import com.huawei.communicate.multipkg.impl.MultiPkgUtil;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.communicate.proxy.impl.AbstractMsgService;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NEProxyService
extends AbstractMsgService
implements IProxyService {
    private static Logger logger = LoggerFactory.getLogger(NEProxyService.class);

    public NEProxyService(ICommServiceAdapter commService) {
        super(commService);
    }

    public int sendMessage(int cmdCode, int neID, FStruct request, FStruct response, int timeOut) {
        return this.sendMessage(MSGHeadBuilder.buildMSGHead(cmdCode, neID), request, response, timeOut);
    }

    public int sendMessage(int cmdCode, int neID, FStruct request, FStruct response) {
        return this.sendMessage(cmdCode, neID, request, response, this.commService.getDefaultTimeOut());
    }

    public int sendAsyncMessage(int cmdCode, int neID, FStruct request, MSGListener listener, int timeOut) {
        return this.sendAsyncMessage(MSGHeadBuilder.buildMSGHead(cmdCode, neID), request, listener, timeOut);
    }

    public int sendAsyncMessage(int cmdCode, int neID, FStruct request, MSGListener listener) {
        return this.sendAsyncMessage(cmdCode, neID, request, listener, this.commService.getDefaultTimeOut());
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, int neID, FStruct request, AbstractMultiPkgReceiver receiver) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo);
        if (0 != result) {
            logger.error("query EM process failed, cmdCode = " + cmdCode + " neID = " + neID);
            return null;
        }
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>(1);
        MultiPkgUtil.addSubRequest(processInfo, neID, request, subReqList);
        MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode, processInfo);
        return MultiPkgCommHandleFactory.getCommHandle(this.commService, head, subReqList, receiver, 1, 0);
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, IPkgSplitter splitter, int cmdStrategy) {
        MSGHead head = MSGHeadBuilder.createMSGHead(cmdCode);
        splitter.setMSGHead(head);
        List<MultiPkgRequest> subReqList = splitter.getSubRequestlst(request);
        if (null == subReqList) {
            logger.error("split pkg failed, cmdCode = " + cmdCode + " request = " + request + "splitter = " + splitter.getClass().getName());
            return null;
        }
        return MultiPkgCommHandleFactory.getCommHandle(this.commService, head, subReqList, receiver, 1, cmdStrategy);
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, List neObjList, String neIDName, int cmdStrategy) {
        DefaultPkgSplitter splitter = new DefaultPkgSplitter(neObjList, neIDName, cmdStrategy);
        return this.getAsyncCommHandle(cmdCode, request, receiver, splitter, cmdStrategy);
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, int neID, FStruct request, AbstractMultiPkgReceiver receiver) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, neID, request, receiver);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, List neObjList, String neIDName, int cmdStrategy) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, request, receiver, neObjList, neIDName, cmdStrategy);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, IPkgSplitter splitter, int cmdStrategy) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, request, receiver, splitter, cmdStrategy);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }
}

