/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.impl;

import com.huawei.communicate.core.AppAidedMsgSyncReceiver;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.receive.IReceiverReference;
import com.huawei.communicate.util.receive.ReceiverUtil;
import java.io.IOException;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommServiceAdapterImpl
implements ICommServiceAdapter {
    private static final int ONE_SECOND = 1000;
    private static final int MSG_SIZE_OVERFLOW = -1;
    private static Logger logger = LoggerFactory.getLogger(CommServiceAdapterImpl.class);
    private CommService delegate;

    public CommServiceAdapterImpl(CommService delegate) {
        this.delegate = delegate;
    }

    public IReceiverReference addMessageListener(int cmdCode, ILiteReceiver receiver) {
        return ReceiverUtil.addMessageListener(cmdCode, this.delegate, receiver);
    }

    public int getDefaultTimeOut() {
        return this.delegate.getTimeout() / 1000;
    }

    public int sendAsyncMessage(MSGHead head, FStruct data, MSGListener listener, int times) {
        if (null == head) {
            logger.error("head is null");
            return 1107296274;
        }
        try {
            short cmdHandle = this.delegate.sendAsyncMessage(head, data, listener, times * 1000);
            if (-1 == cmdHandle) {
                return -2;
            }
            return 0;
        }
        catch (FStruException ex) {
            logger.error("sendAsyncMessage()", (Throwable)ex);
            return -2;
        }
        catch (IOException ex) {
            logger.error("sendAsyncMessage()", (Throwable)ex);
            return -3;
        }
    }

    public int sendAsyncMessage(MSGHead head, FStruct data, MSGListener listener) {
        return this.sendAsyncMessage(head, data, listener, this.getDefaultTimeOut());
    }

    public int sendMessage(MSGHead head, FStruct data, MSGSyncReceiver recv, int time) {
        if (null == head) {
            logger.error("head is null");
            return 1107296274;
        }
        return this.delegate.sendMessage(head, data, recv, time * 1000);
    }

    public int sendMessage(MSGHead head, FStruct data, MSGSyncReceiver recv) {
        return this.sendMessage(head, data, recv, this.delegate.getTimeout() / 1000);
    }

    public int sendMessage(MSGHead msgHead, FStruct request, AppAidedMsgSyncReceiver receiver, int timeOut) {
        if (null == msgHead) {
            logger.error("head is null");
            return 1107296274;
        }
        if (this.delegate instanceof CommHandle) {
            return ((CommHandle)this.delegate).sendMessage(msgHead, request, receiver, timeOut * 1000);
        }
        logger.error("commService is not a CommHandle");
        return 1;
    }
}

