/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.multipkg.impl.MultiPkgCommHandleFactory;
import com.huawei.communicate.multipkg.impl.MultiPkgUtil;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.proxy.IMsgService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.receive.IReceiverReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMsgService
implements IMsgService {
    private static Logger logger = LoggerFactory.getLogger(AbstractMsgService.class);
    protected ICommServiceAdapter commService;

    public AbstractMsgService(ICommServiceAdapter commService) {
        if (null == commService) {
            logger.error("commService can not be null");
            throw new IllegalArgumentException("commService can not be null");
        }
        this.commService = commService;
    }

    @Override
    public int sendMessage(MSGHead msgHead, FStruct request, MSGSyncReceiver recv, int timeOut) {
        return this.commService.sendMessage(msgHead, request, recv, timeOut);
    }

    @Override
    public int sendMessage(MSGHead msgHead, FStruct request, MSGSyncReceiver recv) {
        return this.sendMessage(msgHead, request, recv, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendMessage(MSGHead msgHead, FStruct request, FStruct response, int timeOut) {
        MSGSyncReceiver receiver = new MSGSyncReceiver();
        int result = this.sendMessage(msgHead, request, receiver, timeOut);
        return AsnCoder.deserializeIfOK(result, receiver, response);
    }

    @Override
    public int sendMessage(MSGHead msgHead, FStruct request, FStruct response) {
        return this.sendMessage(msgHead, request, response, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendMessage(int cmdCode, FStruct request, FStruct response, int timeOut) {
        return this.sendMessage(MSGHeadBuilder.buildMSGHead(cmdCode), request, response, timeOut);
    }

    @Override
    public int sendMessage(int cmdCode, FStruct request, FStruct response) {
        return this.sendMessage(cmdCode, request, response, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendAsyncMessage(MSGHead msgHead, FStruct request, MSGListener listener, int timeOut) {
        return this.commService.sendAsyncMessage(msgHead, request, listener, timeOut);
    }

    @Override
    public int sendAsyncMessage(MSGHead msgHead, FStruct request, MSGListener listener) {
        return this.sendAsyncMessage(msgHead, request, listener, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendAsyncMessage(int cmdCode, FStruct request, MSGListener listener, int timeOut) {
        return this.sendAsyncMessage(MSGHeadBuilder.buildMSGHead(cmdCode), request, listener, timeOut);
    }

    @Override
    public int sendAsyncMessage(int cmdCode, FStruct request, MSGListener listener) {
        return this.sendAsyncMessage(cmdCode, request, listener, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendBroadcastMessage(int cmdCode, FStruct request, int timeOut) {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        int result = ProxyUtil.queryAllEMProcess(cmdCode, processes);
        if (0 != result) {
            logger.error("query EM Process failed, sendBroadcaseMessage will return!");
            return result;
        }
        return this.sendBroadcastMessage(cmdCode, processes, request, timeOut);
    }

    protected int sendBroadcastMessage(int cmdCode, List<ProcessInfo> processes, FStruct request, int timeOut) {
        if (processes.isEmpty()) {
            logger.error("no EM Process support, CmdCode = " + cmdCode);
            return -2;
        }
        Iterator<ProcessInfo> iter = processes.iterator();
        int result = -1;
        while (iter.hasNext()) {
            ProcessInfo procInfo = iter.next();
            MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode, procInfo);
            head.msgType = 1;
            int errorCode = this.sendAsyncMessage(head, AsnCoder.asnClone(request), null, timeOut);
            if (0 != errorCode) continue;
            result = errorCode;
        }
        return result;
    }

    @Override
    public int sendBroadcastMessage(MSGHead msgHead, FStruct request, int timeOut) {
        logger.info("sendBroadcastMessage, msgHead = " + msgHead);
        if ('\u0000' != msgHead.receiverProcID) {
            return this.sendAsyncMessage(msgHead, request, null, timeOut);
        }
        return this.sendBroadcastMessage(msgHead.cmdCode, request, timeOut);
    }

    @Override
    public int sendBroadcastMessage(MSGHead msgHead, FStruct request) {
        return this.sendBroadcastMessage(msgHead, request, this.commService.getDefaultTimeOut());
    }

    @Override
    public int sendBroadcastMessage(int cmdCode, FStruct request) {
        return this.sendBroadcastMessage(cmdCode, request, this.commService.getDefaultTimeOut());
    }

    @Override
    public IReceiverReference addMessageListener(int cmdCode, ILiteReceiver receiver) {
        return this.commService.addMessageListener(cmdCode, receiver);
    }

    @Override
    public AbstractMultiPkgCommHandle getAsyncCommHandle(MSGHead msgHead, FStruct request, AbstractMultiPkgReceiver receiver) {
        if (logger.isDebugEnabled()) {
            logger.debug("getAsyncCommHandle, msgHead = " + msgHead);
        }
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        int result = 0;
        if ('\u0000' != msgHead.receiverProcID) {
            if ('\u0000' != msgHead.receiverProcHandle) {
                processes.add(new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle)));
            } else {
                result = ProxyUtil.queryAllEMProcess(msgHead.receiverProcID, processes);
                if (0 == result && processes.isEmpty()) {
                    processes.add(new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle)));
                }
            }
        } else {
            result = ProxyUtil.queryAllEMProcess(msgHead.cmdCode, processes);
        }
        if (0 != result) {
            logger.error("query process failed, result = " + result + ",msgHead = " + msgHead);
            return null;
        }
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>(processes.size());
        MultiPkgUtil.addSubRequest(processes, request, subReqList);
        return MultiPkgCommHandleFactory.getCommHandle(this.commService, msgHead, subReqList, receiver, 1, 2);
    }

    @Override
    public AbstractMultiPkgCommHandle getCommHandle(MSGHead msgHead, FStruct request, AbstractMultiPkgReceiver receiver) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(msgHead, request, receiver);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    @Override
    public int sendResponseMessage(MSGHead msgHead, FStruct reponse, int timeOut) {
        return this.sendAsyncMessage(msgHead, reponse, null, timeOut);
    }

    @Override
    public int sendResponseMessage(MSGHead msgHead, FStruct reponse) {
        return this.sendResponseMessage(msgHead, reponse, this.commService.getDefaultTimeOut());
    }
}

