/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.address;

import com.huawei.communicate.asn1.AsnDevIDList;
import com.huawei.communicate.asn1.AsnDevIDListOfNEMgr;
import com.huawei.communicate.asn1.AsnFrameProcID;
import com.huawei.communicate.asn1.AsnGetDevOwnerReq;
import com.huawei.communicate.asn1.AsnGetDevOwnerRsp;
import com.huawei.communicate.core.AppAidedMsgReceiver;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.proxy.SpecialNeTable;
import com.huawei.communicate.proxy.address.EmGroup;
import com.huawei.communicate.proxy.address.MCProxyMSGHeadBuilder;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.AbstractLiteReceiver;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NeSubareaTable
extends AbstractLiteReceiver {
    private Logger logger = LoggerFactory.getLogger(NeSubareaTable.class);
    private Map<Integer, List<ProcessInfo>> neOwner = new HashMap<Integer, List<ProcessInfo>>();
    private Map<Integer, List<ProcessInfo>> incrementNeOwner = new HashMap<Integer, List<ProcessInfo>>();
    private ReentrantReadWriteLock neAddrTableLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock incrementNeAddrTableLock = new ReentrantReadWriteLock();
    private volatile int loadStatus = 0;
    private EmGroup emGroup;
    private ProcessInfo info = ConnectManager.getDefaultProcessInfo();

    NeSubareaTable() {
        this.emGroup = new EmGroup();
        ICommServiceAdapter commImp = MsgProxy.getCommServiceAdapter(this.info);
        if (commImp != null) {
            commImp.addMessageListener(0x227007, this);
            commImp.addMessageListener(2256904, this);
            commImp.addMessageListener(1134594, this);
        }
        this.startLoad();
    }

    private void startLoad() {
        ThreadPool.getInstance().execute(new Runnable(){

            public void run() {
                NeSubareaTable.this.refreshOwnerProcess();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int refreshOwnerProcess() {
        if (1 == this.loadStatus) {
            return 0;
        }
        this.loadStatus = 1;
        this.neAddrTableLock.writeLock().lock();
        try {
            int result = this.doLoad();
            this.logger.info("refreshOwnerProcess() complete");
            int n = result;
            return n;
        }
        finally {
            this.neAddrTableLock.writeLock().unlock();
        }
    }

    private int doLoad() {
        int result = this.fullLoad(this.createGetDevOwnerReq());
        if (0 != result) {
            this.logger.info("refreshOwnerProcess() failed result = " + result);
            this.loadStatus = 0;
        }
        return result;
    }

    private void parseNeAddressTable(AsnGetDevOwnerRsp rsp, boolean clearOld) {
        this.neAddrTableLock.writeLock().lock();
        if (clearOld) {
            this.neOwner.clear();
        }
        int n = rsp.devOwnerList.size();
        for (int i = 0; i < n; ++i) {
            AsnDevIDListOfNEMgr neMgr = (AsnDevIDListOfNEMgr)rsp.devOwnerList.get(i);
            this.addAddress(neMgr, neMgr.srcProcID);
        }
        this.neAddrTableLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAddress(AsnDevIDListOfNEMgr neMgr, AsnFrameProcID procID) {
        this.neAddrTableLock.writeLock().lock();
        try {
            this.doAddAddress(neMgr, procID, this.neOwner);
        }
        finally {
            this.neAddrTableLock.writeLock().unlock();
        }
    }

    private ProcessInfo createProcessInfo(AsnFrameProcID procID) {
        if (procID.procType == 0 && procID.procHandle == 0) {
            this.logger.error("getNeOwner from MC failed");
            return null;
        }
        return new ProcessInfo(Character.valueOf((char)procID.procType), Character.valueOf((char)procID.procHandle));
    }

    private AsnGetDevOwnerReq createGetDevOwnerReq() {
        AsnGetDevOwnerReq req = new AsnGetDevOwnerReq();
        req.userID = 100;
        return req;
    }

    private int incrementLoad(AsnGetDevOwnerReq req, AsnGetDevOwnerRsp rsp) {
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(0x227002);
        int result = MsgProxy.getProxyService(this.info).sendMessage(head, (FStruct)req, (FStruct)rsp, 60);
        if (0 == result) {
            result = rsp.result;
        }
        if (0 != result) {
            this.logger.error("incrementLoad() failed, result = " + result);
        }
        return result;
    }

    private int fullLoad(AsnGetDevOwnerReq req) {
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(2256902);
        AppAidedMsgReceiver asyncMultiRec = new AppAidedMsgReceiver(){
            int revicePkgCount = 0;

            protected boolean processMessage(MSGPacketExt msg) {
                ++this.revicePkgCount;
                return NeSubareaTable.this.updataNeOwner(msg, this.revicePkgCount);
            }

            protected int handleTimeout() {
                return 0;
            }

            protected boolean isDispatchInvalidPacket() {
                return true;
            }
        };
        int result = MsgProxy.getProxyService(this.info).sendAsyncMessage(head, (FStruct)req, (MSGListener)asyncMultiRec, 60);
        if (0 != result) {
            this.logger.error("fullLoad() failed, result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updataNeOwner(MSGPacketExt msg, int revicePkgCount) {
        this.logger.info("processMessage(), packet = " + msg);
        this.neAddrTableLock.writeLock().lock();
        try {
            boolean isFinished;
            if ('\u0000' != msg.mheader.errCode) {
                this.logger.error("msg.mheader.errCode = " + msg.mheader.errCode);
                this.loadStatus = 0;
                boolean bl = true;
                return bl;
            }
            AsnGetDevOwnerRsp rsp = new AsnGetDevOwnerRsp();
            AsnCoder.deserialize(msg, (FStruct)rsp);
            if (-1 == rsp.totalPkgCnt) {
                this.logger.error("rsp.totalPkgCnt = " + rsp.totalPkgCnt);
                this.loadStatus = 0;
                boolean bl = true;
                return bl;
            }
            this.parseNeAddressTable(rsp, false);
            boolean bl = isFinished = revicePkgCount == rsp.totalPkgCnt;
            if (isFinished) {
                this.loadStatus = 2;
            }
            boolean bl2 = isFinished;
            return bl2;
        }
        finally {
            this.neAddrTableLock.writeLock().unlock();
        }
    }

    int queryEMProcess(int neID, List<ProcessInfo> neOwnerList) {
        int result = this.queryAllNeOwnerProcess(neID, neOwnerList);
        if (0 != result || neOwnerList.isEmpty()) {
            result = this.getProcessesFromSpecialTable(neID, neOwnerList);
        }
        if (0 != result) {
            this.logger.error("query NE Owner Process fail , result = " + result);
            return result;
        }
        LinkedList<ProcessInfo> associatProcList = new LinkedList<ProcessInfo>();
        for (ProcessInfo owner : neOwnerList) {
            this.emGroup.queryAssociateProcesses(owner, associatProcList);
        }
        neOwnerList.addAll(associatProcList);
        return 0;
    }

    int queryProcesses(char procID, Collection<ProcessInfo> processes) {
        return this.emGroup.queryProcesses(procID, processes);
    }

    int queryNeOwnerProcess(int neID, ProcessInfo owner) {
        LinkedList<ProcessInfo> owners = new LinkedList<ProcessInfo>();
        int result = this.queryAllNeOwnerProcess(neID, owners);
        if (0 != result) {
            this.logger.error("queryNeOwnerProcess() failed, result = " + result);
            return result;
        }
        if (1 == owners.size()) {
            ProcessInfo[] infos = owners.toArray(new ProcessInfo[1]);
            owner.resetProcessInfo(infos[0]);
            return 0;
        }
        this.logger.error("queryNeOwnerProcess() owners.size() = " + owners.size());
        return 1107296274;
    }

    int queryAllNeOwnerProcess(int neID, List<ProcessInfo> owners) {
        int result = 1107296274;
        if (1 == this.loadStatus) {
            result = this.loadingStatusQuery(neID, owners);
        } else if (2 == this.loadStatus) {
            result = this.endLoadingStatusQuery(neID, owners);
        } else if (0 == this.loadStatus) {
            result = this.refreshOwnerProcess();
            if (0 != result) {
                this.logger.error("queryAllNeOwnerProcess()-->refreshOwnerProcess() failed");
            } else if (0 != this.loadStatus) {
                result = this.queryAllNeOwnerProcess(neID, owners);
            }
        }
        return result;
    }

    private int loadingStatusQuery(int neID, Collection<ProcessInfo> owners) {
        Collection<ProcessInfo> tmp = null;
        if (this.neAddrTableLock.readLock().tryLock()) {
            tmp = this.getNeOwnerProcess(neID);
            this.neAddrTableLock.readLock().unlock();
        } else {
            tmp = this.getNeOwnerProcessFromIncrementTable(neID);
        }
        if (null != tmp && !tmp.isEmpty()) {
            owners.addAll(tmp);
            return 0;
        }
        return this.getNeOwnerProcessFromSocketByIncrement(neID, true, owners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int endLoadingStatusQuery(int neID, List<ProcessInfo> owners) {
        List<ProcessInfo> tmp = this.getNeOwnerProcess(neID);
        if (null != tmp && !tmp.isEmpty()) {
            owners.addAll(tmp);
            return 0;
        }
        this.incrementNeAddrTableLock.writeLock().lock();
        try {
            this.incrementNeOwner.clear();
        }
        finally {
            this.incrementNeAddrTableLock.writeLock().unlock();
        }
        return this.getNeOwnerProcessFromSocketByIncrement(neID, false, owners);
    }

    private int getNeOwnerProcessFromSocketByIncrement(int neID, boolean isIncrement, Collection<ProcessInfo> owners) {
        int result = this.getIncrementTableFromSocket(neID, isIncrement);
        if (0 != result) {
            this.logger.error("getAddTableFromSocket() failed, result = " + result);
            return result;
        }
        Collection<ProcessInfo> tmp = null;
        tmp = isIncrement ? this.getNeOwnerProcessFromIncrementTable(neID) : this.getNeOwnerProcess(neID);
        if (null == tmp || tmp.isEmpty()) {
            this.logger.error("getAddTableFromSocket() failed, beause getNeOwnerProcessFromIncrementTable() failed");
            return 1107296274;
        }
        owners.addAll(tmp);
        return 0;
    }

    private int getIncrementTableFromSocket(int neID, boolean isIncrement) {
        AsnGetDevOwnerReq req = this.createGetDevOwnerReq();
        AsnDevIDList devlst = new AsnDevIDList();
        devlst.add(BigInteger.valueOf(neID));
        req.devIDList = devlst;
        AsnGetDevOwnerRsp rsp = new AsnGetDevOwnerRsp();
        int result = this.incrementLoad(req, rsp);
        if (0 == result) {
            result = rsp.result;
        }
        if (0 != result) {
            this.logger.error("getAddTableFromSocket() failed, result = " + result);
            return result;
        }
        if (!isIncrement) {
            this.parseNeAddressTable(rsp, false);
        } else {
            this.parseIncrementNeOwnerTable(rsp);
        }
        return result;
    }

    private void parseIncrementNeOwnerTable(AsnGetDevOwnerRsp rsp) {
        this.incrementNeAddrTableLock.writeLock().lock();
        int n = rsp.devOwnerList.size();
        for (int i = 0; i < n; ++i) {
            AsnDevIDListOfNEMgr neMgr = (AsnDevIDListOfNEMgr)rsp.devOwnerList.get(i);
            this.addIncrementAddress(neMgr, neMgr.srcProcID);
        }
        this.incrementNeAddrTableLock.writeLock().unlock();
    }

    private void doAddAddress(AsnDevIDListOfNEMgr neMgr, AsnFrameProcID procID, Map<Integer, List<ProcessInfo>> willBeAdded) {
        ProcessInfo processInfo = this.createProcessInfo(procID);
        if (null == processInfo) {
            return;
        }
        int n = neMgr.devIDList.size();
        for (int i = 0; i < n; ++i) {
            List<Object> owners;
            int devID = ((BigInteger)neMgr.devIDList.get(i)).intValue();
            if (willBeAdded.containsKey(devID)) {
                owners = willBeAdded.get(devID);
            } else {
                owners = new LinkedList();
                willBeAdded.put(devID, owners);
            }
            if (owners.contains(processInfo)) continue;
            owners.add(processInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIncrementAddress(AsnDevIDListOfNEMgr neMgr, AsnFrameProcID procID) {
        this.incrementNeAddrTableLock.writeLock().lock();
        try {
            this.doAddAddress(neMgr, procID, this.incrementNeOwner);
        }
        finally {
            this.incrementNeAddrTableLock.writeLock().unlock();
        }
    }

    private List<ProcessInfo> getNeOwnerProcess(int neID) {
        this.neAddrTableLock.readLock().lock();
        List<ProcessInfo> processes = this.neOwner.get(neID);
        this.neAddrTableLock.readLock().unlock();
        return processes;
    }

    private Collection<ProcessInfo> getNeOwnerProcessFromIncrementTable(int neID) {
        this.incrementNeAddrTableLock.readLock().lock();
        Collection processes = this.incrementNeOwner.get(neID);
        this.incrementNeAddrTableLock.readLock().unlock();
        return processes;
    }

    private int getProcessesFromSpecialTable(int neID, Collection<ProcessInfo> container) {
        List<Character> procIDList = SpecialNeTable.getProcessesByNeID(neID);
        Iterator<Character> iter = procIDList.iterator();
        HashSet<ProcessInfo> set = new HashSet<ProcessInfo>();
        int result = 1107296274;
        while (iter.hasNext()) {
            int errorCode = this.queryProcesses(iter.next().charValue(), set);
            if (0 == result) continue;
            result = errorCode;
        }
        container.addAll(set);
        return result;
    }

    private boolean isSupportedCmd(int cmdCode) {
        return 0x227007 == cmdCode || 2256904 == cmdCode || 1134594 == cmdCode;
    }

    @Override
    public void processMessage(MSGPacketExt packet) {
        int cmdCode = packet.mheader.cmdCode;
        this.logger.info("processMessage(), packet = " + packet + "cmdCode = " + cmdCode);
        if (!this.isSupportedCmd(cmdCode)) {
            this.logger.info("processMessage(), unknow cmdCode, packet = " + packet + "cmdCode = " + cmdCode);
            return;
        }
        AsnDevIDListOfNEMgr rsp = this.decodeNEOwnerChangeEvent(packet);
        switch (cmdCode) {
            case 0x227007: {
                this.notifyNEAdded(rsp);
                break;
            }
            case 2256904: {
                this.notifyNEDeleted(rsp);
                break;
            }
            case 1134594: {
                this.notifyNETransfered(rsp);
                break;
            }
            default: {
                this.logger.info("processMessage(), receive a unknown msgpacket");
            }
        }
    }

    private AsnDevIDListOfNEMgr decodeNEOwnerChangeEvent(MSGPacketExt packet) {
        AsnDevIDListOfNEMgr rsp = new AsnDevIDListOfNEMgr();
        AsnCoder.deserialize(packet, (FStruct)rsp);
        return rsp;
    }

    private void notifyNEAdded(AsnDevIDListOfNEMgr event) {
        this.neAddrTableLock.writeLock().lock();
        int n = event.devIDList.size();
        for (int i = 0; i < n; ++i) {
            int devID = ((BigInteger)event.devIDList.get(i)).intValue();
            this.neOwner.remove(devID);
        }
        this.neAddrTableLock.writeLock().unlock();
        this.addAddress(event, event.snkProcID != null ? event.snkProcID : event.srcProcID);
    }

    private void notifyNEDeleted(AsnDevIDListOfNEMgr event) {
        this.neAddrTableLock.writeLock().lock();
        int n = event.devIDList.size();
        for (int i = 0; i < n; ++i) {
            int devID = ((BigInteger)event.devIDList.get(i)).intValue();
            if (!this.neOwner.containsKey(devID)) {
                this.logger.warn("neOwner not contains key-->" + devID);
                continue;
            }
            this.neOwner.remove(devID);
        }
        this.neAddrTableLock.writeLock().unlock();
    }

    private void notifyNETransfered(AsnDevIDListOfNEMgr event) {
        this.neAddrTableLock.writeLock().lock();
        ProcessInfo target = this.createProcessInfo(event.snkProcID);
        if (null == target) {
            return;
        }
        int n = event.devIDList.size();
        for (int i = 0; i < n; ++i) {
            int devID = ((BigInteger)event.devIDList.get(i)).intValue();
            if (!this.neOwner.containsKey(devID)) {
                this.logger.warn("neOwner not contains key-->" + devID);
                continue;
            }
            this.neOwner.remove(devID);
            LinkedList<ProcessInfo> processInfos = new LinkedList<ProcessInfo>();
            processInfos.add(target);
            this.neOwner.put(devID, processInfos);
        }
        this.neAddrTableLock.writeLock().unlock();
    }
}

