/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.address;

import com.huawei.communicate.asn1.AsnDevInst;
import com.huawei.communicate.asn1.AsnDevTypeList;
import com.huawei.communicate.asn1.AsnFrameProcID;
import com.huawei.communicate.asn1.AsnGetDevInstReq;
import com.huawei.communicate.asn1.AsnGetDevInstRsp;
import com.huawei.communicate.asn1.AsnGetNEMgrSupportDevTypeReq;
import com.huawei.communicate.asn1.AsnGetNEMgrSupportDevTypeRsp;
import com.huawei.communicate.asn1.AsnNemgrInst;
import com.huawei.communicate.asn1.AsnNemgrInstList;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.proxy.address.CmdAddress;
import com.huawei.communicate.proxy.address.MCProxyMSGHeadBuilder;
import com.huawei.communicate.proxy.address.NeSubareaTable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MCProxy {
    private static Logger logger = LoggerFactory.getLogger(MCProxy.class);
    private static MCProxy _Instance = null;
    private CmdAddress cmdAddress;
    private NeSubareaTable neSubareaTable = new NeSubareaTable();

    private MCProxy() {
        this.cmdAddress = new CmdAddress();
    }

    public static synchronized MCProxy getInstance() {
        if (null == _Instance) {
            _Instance = new MCProxy();
        }
        return _Instance;
    }

    public int queryEMProcess(int cmdCode, int neID, ProcessInfo processInfo) {
        LinkedList<Character> procIDList = new LinkedList<Character>();
        int result = this.cmdAddress.queryProcessesByCmdCode(cmdCode, procIDList);
        if (0 != result) {
            logger.error("queryProcessesByCmdCode() failed, result = " + result);
            return result;
        }
        LinkedList<ProcessInfo> processesByNeID = new LinkedList<ProcessInfo>();
        result = this.neSubareaTable.queryEMProcess(neID, processesByNeID);
        if (0 != result) {
            logger.error("queryEMProcess() failed, result = " + result);
            return result;
        }
        return this.intersectProcessInfo(procIDList, processesByNeID, processInfo);
    }

    public int queryEMProcess(int neID, char procID, ProcessInfo processInfo) {
        ArrayList<Character> procIDList = new ArrayList<Character>();
        procIDList.add(Character.valueOf(procID));
        ArrayList<ProcessInfo> processesByNeID = new ArrayList<ProcessInfo>();
        int result = this.neSubareaTable.queryEMProcess(neID, processesByNeID);
        if (0 != result) {
            logger.error("queryEMProcess() failed, result = " + result);
            return result;
        }
        return this.intersectProcessInfo(procIDList, processesByNeID, processInfo);
    }

    public int queryProcesses(char procID, Collection<ProcessInfo> processes) {
        return this.neSubareaTable.queryProcesses(procID, processes);
    }

    public int queryAllEMProcess(int cmdCode, List<ProcessInfo> processes) {
        ArrayList<Character> procIDList = new ArrayList<Character>();
        int result = this.cmdAddress.queryProcessesByCmdCode(cmdCode, procIDList);
        if (0 != result) {
            logger.error("queryAllEMProcess() failed, result = " + result);
            return result;
        }
        HashSet<Character> proIDSet = new HashSet<Character>(procIDList);
        for (Character procID : proIDSet) {
            result = this.neSubareaTable.queryProcesses(procID.charValue(), processes);
            if (0 == result) continue;
            logger.error("queryAllEMProcess() failed, result = " + result + ", procID = " + procID.charValue());
            break;
        }
        if (processes.isEmpty()) {
            logger.error("queryAllEMProcess() sucess, processes is empty,cmdCode=" + cmdCode);
        }
        return result;
    }

    public int queryNoEMProcess(int cmdCode, ProcessInfo processInfo) {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        int result = this.queryAllEMProcess(cmdCode, processes);
        if (0 != result) {
            logger.error("queryNoEMProcess() failed, result = " + result);
            return result;
        }
        if (1 == processes.size()) {
            processInfo.resetProcessInfo((ProcessInfo)processes.get(0));
            return 0;
        }
        logger.error("queryNoEMProcess() failed, processes.size() = " + processes.size());
        return 1107296274;
    }

    public int getProcessInfoFromSocket(int cmdCode, int neID, ProcessInfo processInfo) {
        int result = this.cmdAddress.refreshCmdTable();
        if (0 != result) {
            logger.error("getProcessInfoFromSocket, refreshCmdTable() failed, result = " + result);
            return result;
        }
        return this.queryEMProcess(cmdCode, neID, processInfo);
    }

    private int intersectProcessInfo(List<Character> procIDList, List<ProcessInfo> processesByNeID, ProcessInfo processInfo) {
        if (logger.isDebugEnabled()) {
            StringBuffer cmdProcStr = new StringBuffer();
            cmdProcStr.append("cmd proclist is");
            for (char procid : procIDList) {
                cmdProcStr.append((int)procid).append(',');
            }
            StringBuffer neProcStr = new StringBuffer();
            neProcStr.append("ne proclist is");
            for (ProcessInfo info : processesByNeID) {
                neProcStr.append((int)info.getProcID().charValue()).append(':').append((int)info.getProcHandle().charValue()).append(',');
            }
            logger.error(cmdProcStr.toString());
            logger.error(neProcStr.toString());
        }
        if (!procIDList.isEmpty() && !processesByNeID.isEmpty()) {
            for (ProcessInfo oneProcess : processesByNeID) {
                if (!procIDList.contains(oneProcess.getProcID())) continue;
                processInfo.resetProcessInfo(oneProcess);
                return 0;
            }
        }
        return 1107296274;
    }

    public int queryProcessInfoByNeID(int neID, ProcessInfo processInfo) {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        int result = this.neSubareaTable.queryEMProcess(neID, processes);
        if (0 != result) {
            logger.error("getProcessInfoByNeID() failed, result = " + result);
            return result;
        }
        if (processes.size() == 1) {
            processInfo.resetProcessInfo((ProcessInfo)processes.get(0));
            return 0;
        }
        logger.error("queryProcessInfoByNeID() failed, processes.size() = " + processes.size());
        return 1107296274;
    }

    public int getProcessInfoByDevtype(int devType, ProcessInfo processInfo) {
        AsnGetNEMgrSupportDevTypeReq req = new AsnGetNEMgrSupportDevTypeReq();
        req.devType = BigInteger.valueOf(devType);
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(2256899);
        AsnGetNEMgrSupportDevTypeRsp rsp = new AsnGetNEMgrSupportDevTypeRsp();
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp);
        if (0 == result) {
            result = rsp.errCode;
        }
        if (0 != result) {
            logger.error("getProcessInfoByDevtype() failed, result = " + result);
            return result;
        }
        if (rsp.neMgrList.isEmpty()) {
            logger.error("getProcessInfoByDevtype() failed, rsp.neMgrList is empty");
            return 1107296274;
        }
        AsnNemgrInst neMgr = (AsnNemgrInst)rsp.neMgrList.get(0);
        processInfo.resetProcessInfo(this.createProcessInfo(neMgr));
        return 0;
    }

    private ProcessInfo createProcessInfo(AsnNemgrInst neMgr) {
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setProcID((char)neMgr.procID.procType);
        processInfo.setProcHandle((char)neMgr.procID.procHandle);
        return processInfo;
    }

    public int queryNeOwnerProcess(int neID, ProcessInfo owner) {
        return this.neSubareaTable.queryNeOwnerProcess(neID, owner);
    }

    public int queryProcessLst(int neID, List<ProcessInfo> lst) {
        return this.neSubareaTable.queryEMProcess(neID, lst);
    }

    public static int queryNEIDList(List<Integer> neTypeList, List<Integer> neIDList) {
        AsnGetDevInstReq req = new AsnGetDevInstReq();
        req.userID = 100;
        if (null != neTypeList && !neTypeList.isEmpty()) {
            req.devTypeList = new AsnDevTypeList();
            int n = neTypeList.size();
            for (int i = 0; i < n; ++i) {
                Integer integer = neTypeList.get(i);
                req.devTypeList.add(BigInteger.valueOf(integer.intValue()));
            }
        }
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(2256901);
        AsnGetDevInstRsp rsp = new AsnGetDevInstRsp();
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp, 120);
        if (0 == result) {
            result = rsp.result;
        }
        if (0 != result) {
            logger.error("queryNEIDList() failed, result = " + result);
            return result;
        }
        int n = rsp.devList.size();
        for (int i = 0; i < n; ++i) {
            AsnDevInst devInst = (AsnDevInst)rsp.devList.get(i);
            neIDList.add(devInst.devID);
        }
        return 0;
    }

    public static int queryProcess(int devType, String ip, ProcessInfo processInfo) {
        AsnGetNEMgrSupportDevTypeReq req = new AsnGetNEMgrSupportDevTypeReq();
        req.ipAddr = ip.getBytes();
        req.devType = BigInteger.valueOf(devType);
        AsnGetNEMgrSupportDevTypeRsp rsp = new AsnGetNEMgrSupportDevTypeRsp();
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(2256899);
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp, 60);
        if (result != 0) {
            logger.error("queryProcess() failed, result = " + result);
            return result;
        }
        AsnNemgrInstList list = rsp.neMgrList;
        AsnNemgrInst neMgr = null;
        if (!list.isEmpty()) {
            neMgr = (AsnNemgrInst)list.get(0);
            AsnFrameProcID processID = neMgr.procID;
            ProcessInfo info = new ProcessInfo(Character.valueOf((char)processID.procType), Character.valueOf((char)processID.procHandle));
            logger.trace("Test : procID : " + processID.procType + " handle : " + processID.procHandle);
            processInfo.resetProcessInfo(info);
        } else {
            logger.error("queryProcess() failed, empty list returned from AsnGetNEMgrSupportDevTypeRsp with cmd :2256899");
        }
        return 0;
    }
}

