/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.address;

import com.huawei.communicate.asn1.AsnAssociateProcess;
import com.huawei.communicate.asn1.AsnEMGroup;
import com.huawei.communicate.asn1.AsnFrameProcID;
import com.huawei.communicate.asn1.AsnGetAllEMGroupReq;
import com.huawei.communicate.asn1.AsnGetAllEMGroupRsp;
import com.huawei.communicate.asn1.AsnGetEmProcByProcTypeReq;
import com.huawei.communicate.asn1.AsnGetEmProcByProcTypeRsp;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.proxy.address.MCProxyMSGHeadBuilder;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmGroup {
    private Logger logger = LoggerFactory.getLogger(EmGroup.class);
    private Map<ProcessInfo, Collection<ProcessInfo>> emGroups = new HashMap<ProcessInfo, Collection<ProcessInfo>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int loadStatus = 0;
    private volatile boolean refreshed = false;

    EmGroup() {
        this.startLoad();
    }

    private void startLoad() {
        ThreadPool.getInstance().execute(new Runnable(){

            public void run() {
                EmGroup.this.loadEMGroup();
            }
        });
    }

    private int ensureEmGroup() {
        if (0 == this.loadStatus) {
            this.logger.info("ensureEmGroup(), loadStatus is init, will loadEMGroup()");
            return this.loadEMGroup();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadEMGroup() {
        if (1 == this.loadStatus) {
            return 0;
        }
        this.lock.writeLock().lock();
        try {
            this.loadStatus = 1;
            AsnGetAllEMGroupReq req = new AsnGetAllEMGroupReq();
            req.userID = 100;
            MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(1134595);
            AsnGetAllEMGroupRsp rsp = new AsnGetAllEMGroupRsp();
            int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp, 60);
            if (0 == result) {
                result = rsp.result;
            }
            if (0 != result) {
                this.logger.error("loadEMGroup() failed, result = " + result);
                this.loadStatus = 0;
            } else {
                this.refreshed = true;
                this.parseEmGroups(rsp);
                this.loadStatus = 2;
            }
            this.logger.info("loadEMGroup(), complete...");
            int n = result;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void parseEmGroups(AsnGetAllEMGroupRsp rsp) {
        this.emGroups.clear();
        int n = rsp.allEMGroup.size();
        for (int i = 0; i < n; ++i) {
            AsnEMGroup emGroup = (AsnEMGroup)rsp.allEMGroup.get(i);
            ProcessInfo owner = this.createProcessInfo(emGroup.owner);
            Collection<ProcessInfo> processes = this.createAssociateProcesses(emGroup.assoProc);
            this.emGroups.put(owner, processes);
        }
    }

    private Collection<ProcessInfo> createAssociateProcesses(AsnAssociateProcess associate) {
        HashSet<ProcessInfo> processes = new HashSet<ProcessInfo>(associate.size());
        int n = associate.size();
        for (int i = 0; i < n; ++i) {
            processes.add(this.createProcessInfo((AsnFrameProcID)associate.get(i)));
        }
        return processes;
    }

    private ProcessInfo createProcessInfo(AsnFrameProcID procID) {
        return new ProcessInfo(Character.valueOf((char)procID.procType), Character.valueOf((char)procID.procHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queryAssociateProcesses(ProcessInfo owner, Collection<ProcessInfo> processes) {
        int result = this.ensureEmGroup();
        Collection<ProcessInfo> tmp = null;
        this.lock.readLock().lock();
        try {
            if (0 != result || this.emGroups.isEmpty() && this.refreshed) {
                this.logger.error("queryEMProcess(), result = " + result);
                int n = result;
                return n;
            }
            tmp = this.emGroups.get(owner);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (2 == this.loadStatus && null == tmp && !this.refreshed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("queryAssociateProcesses(), not found good processes, will loadEMGroup()");
            }
            if (0 != (result = this.loadEMGroup())) {
                this.logger.info("loadEmGroup() failed, result = " + result);
                return result;
            }
            return this.queryAssociateProcesses(owner, processes);
        }
        if (null != tmp && !tmp.isEmpty()) {
            processes.addAll(tmp);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.error("queryAssociateProcesses() failed, emGroups not contain owner = " + owner);
        }
        return result;
    }

    int queryProcesses(char procType, Collection<ProcessInfo> processes) {
        AsnGetEmProcByProcTypeReq req = new AsnGetEmProcByProcTypeReq();
        req.procType = procType;
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(4193223);
        AsnGetEmProcByProcTypeRsp rsp = new AsnGetEmProcByProcTypeRsp();
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp);
        if (0 == result) {
            result = rsp.errCode;
        }
        if (0 == result) {
            int size = rsp.procIDList.size();
            for (int i = 0; i < size; ++i) {
                ProcessInfo processInfo = new ProcessInfo();
                AsnFrameProcID procID = (AsnFrameProcID)rsp.procIDList.get(i);
                if (procType != (char)procID.procType) continue;
                processInfo.setProcID((char)procID.procType);
                processInfo.setProcHandle((char)procID.procHandle);
                processes.add(processInfo);
            }
        }
        return result;
    }
}

