/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy.address;

import com.huawei.communicate.asn1.AsnGetCmdProcReq;
import com.huawei.communicate.asn1.AsnGetCmdProcRsp;
import com.huawei.communicate.asn1.AsnGetCmdProcSingleReq;
import com.huawei.communicate.asn1.AsnGetCmdProcSingleRsp;
import com.huawei.communicate.asn1.AsnIntegerList;
import com.huawei.communicate.asn1.AsnMoudleCmdList;
import com.huawei.communicate.asn1.AsnMoudleCmdNode;
import com.huawei.communicate.asn1.AsnOctStringList;
import com.huawei.communicate.asn1.AsnProcMoudleList;
import com.huawei.communicate.asn1.AsnProcMoudleNode;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.proxy.address.MCProxyMSGHeadBuilder;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.AbstractLiteReceiver;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmdAddress
extends AbstractLiteReceiver {
    private Logger logger = LoggerFactory.getLogger(CmdAddress.class);
    private Map<Integer, Set<Character>> cmdAddrTable = new ConcurrentHashMap<Integer, Set<Character>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int loadStatus = 0;
    private volatile boolean refreshed = false;

    CmdAddress() {
        this.startLoad();
    }

    private void startLoad() {
        ThreadPool.getInstance().execute(new Runnable(){

            public void run() {
                CmdAddress.this.refreshCmdTable();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queryProcessesByCmdCode(int cmdCode, List<Character> processes) {
        int result = this.ensureCmdAddress();
        Set<Character> procIDs = null;
        this.lock.readLock().lock();
        try {
            if (0 != result) {
                this.logger.info("getProcessesByCmdCode(), cmdCode = " + cmdCode + "result = " + result);
                int n = result;
                return n;
            }
            procIDs = this.cmdAddrTable.get(cmdCode);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (2 == this.loadStatus && null == procIDs && !this.refreshed) {
            this.logger.info("getProcessesByCmdCode(), not found good processes, will refreshCmdTable()");
            this.startLoad();
        }
        if (null != procIDs) {
            processes.addAll(procIDs);
        } else {
            result = this.getProcIDListFromMC(cmdCode, processes);
        }
        return result;
    }

    private int ensureCmdAddress() {
        if (0 == this.loadStatus) {
            this.logger.info("ensureCmdAddress(), loadStatus is init, will refreshCmdTable()");
            return this.refreshCmdTable();
        }
        return 0;
    }

    private void parseCmdAddressTable(AsnGetCmdProcRsp cmdRsp) {
        if (null != this.cmdAddrTable) {
            this.cmdAddrTable.clear();
        }
        AsnMoudleCmdList cmdList = cmdRsp.moudleCmdList;
        AsnProcMoudleList procList = cmdRsp.procMoudleList;
        Map<String, Set<Integer>> moduleCmdMap = this.getModuleCmdMap(cmdList);
        Map<String, Set<Character>> moduleProcMap = this.getModuleProcMap(procList);
        this.constructCmdTable(moduleCmdMap, moduleProcMap);
        moduleCmdMap.clear();
        moduleProcMap.clear();
    }

    private Map<String, Set<Character>> getModuleProcMap(AsnProcMoudleList procModuleList) {
        ConcurrentHashMap<String, Set<Character>> moduleProcMap = new ConcurrentHashMap<String, Set<Character>>();
        AsnProcMoudleNode procModuleNode = null;
        AsnOctStringList moduleList = null;
        String module = null;
        int size = procModuleList.size();
        for (int i = 0; i < size; ++i) {
            procModuleNode = (AsnProcMoudleNode)procModuleList.get(i);
            moduleList = procModuleNode.cMoudlelist;
            int len = moduleList.size();
            for (int j = 0; j < len; ++j) {
                module = new String((byte[])moduleList.get(j));
                if (!moduleProcMap.containsKey(module)) {
                    moduleProcMap.put(module, new HashSet());
                }
                ((Set)moduleProcMap.get(module)).add(Character.valueOf((char)procModuleNode.procType));
            }
        }
        return moduleProcMap;
    }

    private Map<String, Set<Integer>> getModuleCmdMap(AsnMoudleCmdList moduleCmdList) {
        ConcurrentHashMap<String, Set<Integer>> moduleCmdMap = new ConcurrentHashMap<String, Set<Integer>>();
        AsnMoudleCmdNode moduleCmdNode = null;
        AsnIntegerList cmdList = null;
        String module = null;
        int size = moduleCmdList.size();
        for (int i = 0; i < size; ++i) {
            moduleCmdNode = (AsnMoudleCmdNode)moduleCmdList.get(i);
            cmdList = moduleCmdNode.iCmdCodeList;
            module = new String(moduleCmdNode.cMoudlePath);
            if (!moduleCmdMap.containsKey(module)) {
                moduleCmdMap.put(module, new HashSet());
            }
            int len = cmdList.size();
            for (int j = 0; j < len; ++j) {
                ((Set)moduleCmdMap.get(module)).add(((BigInteger)cmdList.get(j)).intValue());
            }
        }
        return moduleCmdMap;
    }

    private void constructCmdTable(Map<String, Set<Integer>> moduleCmdMap, Map<String, Set<Character>> moduleProcMap) {
        Set<Map.Entry<String, Set<Integer>>> moduleCmdMapEntrySet = moduleCmdMap.entrySet();
        for (Map.Entry<String, Set<Integer>> oneModuleCmdMap : moduleCmdMapEntrySet) {
            String module = oneModuleCmdMap.getKey();
            if (!moduleProcMap.containsKey(module)) continue;
            Set<Integer> cmdSet = oneModuleCmdMap.getValue();
            Set<Character> procSet = moduleProcMap.get(module);
            for (Integer cmdCode : cmdSet) {
                if (!this.cmdAddrTable.containsKey(cmdCode)) {
                    this.cmdAddrTable.put(cmdCode, new HashSet());
                }
                this.cmdAddrTable.get(cmdCode).addAll(procSet);
            }
        }
    }

    private int queryCmdList(AsnGetCmdProcRsp rsp) {
        AsnGetCmdProcReq req = new AsnGetCmdProcReq();
        req.iUserID = 100;
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(1134598, (byte)0);
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp, 60);
        if (0 == result) {
            result = rsp.iResult;
        }
        if (0 != result) {
            this.logger.error("queryCmdList() failed, result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshCmdTable() {
        if (1 == this.loadStatus) {
            return 0;
        }
        this.logger.info("refreshCmdTable(), begin...");
        this.lock.writeLock().lock();
        try {
            this.loadStatus = 1;
            AsnGetCmdProcRsp rsp = new AsnGetCmdProcRsp();
            int result = this.queryCmdList(rsp);
            if (0 == result) {
                this.refreshed = true;
                this.parseCmdAddressTable(rsp);
                this.loadStatus = 2;
            } else {
                this.loadStatus = 0;
            }
            this.logger.info("refreshCmdTable(), complete...");
            int n = result;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    int getProcIDListFromMC(int cmdCode, List<Character> processes) {
        AsnGetCmdProcSingleReq req = new AsnGetCmdProcSingleReq();
        req.iUserID = 100;
        req.iCmdCode = cmdCode;
        AsnGetCmdProcSingleRsp rsp = new AsnGetCmdProcSingleRsp();
        MSGHead head = MCProxyMSGHeadBuilder.buildMSGHead(1134599, (byte)0);
        int result = MsgProxy.getProxyService(ConnectManager.getDefaultProcessInfo()).sendMessage(head, (FStruct)req, (FStruct)rsp, 60);
        if (0 == result) {
            result = rsp.iResult;
        }
        if (0 != result) {
            this.logger.error("getProcIDListFromMC() failed, result = " + result);
        } else {
            this.parseCmdSingleTable(rsp, processes);
        }
        return result;
    }

    private void parseCmdSingleTable(AsnGetCmdProcSingleRsp rsp, List<Character> processes) {
        AsnIntegerList procIDList = rsp.procTypeList;
        for (int i = 0; i < procIDList.size(); ++i) {
            int procID = ((BigInteger)procIDList.get(i)).intValue();
            processes.add(Character.valueOf((char)procID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processMessage(MSGPacketExt packet) {
        this.logger.debug("processMessage(), packet = " + packet);
        AsnGetCmdProcRsp rsp = new AsnGetCmdProcRsp();
        AsnCoder.deserialize(packet, (FStruct)rsp);
        this.lock.writeLock().lock();
        try {
            this.parseCmdAddressTable(rsp);
            this.refreshed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

