/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy;

import com.huawei.communicate.util.storage.SuperMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecialNeTable {
    private static SuperMap<Integer, Character> table = new SuperMap();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private SpecialNeTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(int neID, char processID) {
        lock.writeLock().lock();
        try {
            table.put(neID, Character.valueOf(processID));
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(List<Integer> neIDList, char processID) {
        lock.writeLock().lock();
        try {
            for (int i = 0; i < neIDList.size(); ++i) {
                table.put(neIDList.get(i), Character.valueOf(processID));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        lock.writeLock().lock();
        try {
            table.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static List<Character> getProcessesByNeID(int neID) {
        lock.readLock().lock();
        List<Character> result = table.getValuesByKey(neID);
        lock.readLock().unlock();
        return result;
    }

    public static List<Integer> getSupportedNeID(char processID) {
        lock.readLock().lock();
        List<Integer> result = table.getKeysByValue(Character.valueOf(processID));
        lock.readLock().unlock();
        return result;
    }

    public static void remove(int neID) {
        ArrayList<Integer> neIDList = new ArrayList<Integer>();
        neIDList.add(neID);
        SpecialNeTable.remove(neIDList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void remove(List<Integer> neIDList) {
        lock.writeLock().lock();
        try {
            int i = 0;
            while (i < neIDList.size()) {
                List<Character> list = table.getValuesByKey(neIDList.get(i));
                if (list.size() > 1) {
                    for (int j = 0; j < list.size(); ++j) {
                        table.remove(neIDList.get(i));
                    }
                } else {
                    table.remove(neIDList.get(i));
                }
                ++i;
            }
            return;
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

