/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.impl.CommServiceAdapterImpl;
import com.huawei.communicate.proxy.impl.NEProxyService;
import java.util.HashMap;
import java.util.Map;

public final class MsgProxy {
    private static Map<ProcessInfo, IProxyService> proxyCache = new HashMap<ProcessInfo, IProxyService>();
    private static Map<ProcessInfo, ICommServiceAdapter> adapterCache = new HashMap<ProcessInfo, ICommServiceAdapter>();

    private MsgProxy() {
    }

    public static CommService getCommService(ProcessInfo info) {
        CommService service = ConnectManager.getCommService(info);
        return service;
    }

    public static synchronized IProxyService getProxyService(ProcessInfo info) {
        if (proxyCache.containsKey(info)) {
            return proxyCache.get(info);
        }
        ICommServiceAdapter commServiceAdapter = MsgProxy.getCommServiceAdapter(info);
        if (commServiceAdapter == null) {
            return null;
        }
        NEProxyService proxyService = new NEProxyService(commServiceAdapter);
        proxyCache.put(info, proxyService);
        return proxyService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProxyService(ProcessInfo info) {
        Map<ProcessInfo, IProxyService> map = proxyCache;
        synchronized (map) {
            proxyCache.remove(info);
            MsgProxy.removeServiceAdapter(info);
            CommService service = ConnectManager.removeService(info);
            if (null != service) {
                CommHandle handle = (CommHandle)service;
                handle.close();
            }
        }
    }

    public static synchronized ICommServiceAdapter getCommServiceAdapter(ProcessInfo info) {
        if (adapterCache.keySet().contains(info)) {
            return adapterCache.get(info);
        }
        CommService service = ConnectManager.connect(info);
        if (service == null) {
            return null;
        }
        CommServiceAdapterImpl commServiceAdapter = new CommServiceAdapterImpl(service);
        adapterCache.put(info, commServiceAdapter);
        return commServiceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServiceAdapter(ProcessInfo info) {
        Map<ProcessInfo, ICommServiceAdapter> map = adapterCache;
        synchronized (map) {
            adapterCache.remove(info);
        }
    }
}

