/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.proxy;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.ProxyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MSGHeadBuilder {
    private static Logger logger = LoggerFactory.getLogger(MSGHeadBuilder.class);

    private MSGHeadBuilder() {
    }

    public static MSGHead convertToResoponseMSGHead(MSGHead requestMsgHead) {
        byte[] bytes = requestMsgHead.toByte();
        MSGHead response = new MSGHead();
        try {
            response.fromByte(bytes);
        }
        catch (Exception ex) {
            logger.error("convertToResoponseMSGHead()", (Throwable)ex);
        }
        response.receiverDeskID = requestMsgHead.senderDeskID;
        response.receiverModule = requestMsgHead.senderModule;
        response.receiverProcID = requestMsgHead.senderProcID;
        response.receiverProcHandle = requestMsgHead.senderProcHandle;
        response.cmdHandle = requestMsgHead.senderCmdHandle;
        response.senderDeskID = requestMsgHead.receiverDeskID;
        response.senderModule = requestMsgHead.receiverModule;
        response.senderProcID = requestMsgHead.receiverProcID;
        response.senderProcHandle = requestMsgHead.receiverProcHandle;
        response.senderCmdHandle = requestMsgHead.cmdHandle;
        response.msgType = (byte)7;
        return response;
    }

    public static MSGHead createMSGHead(int cmdCode) {
        MSGHead head = new MSGHead();
        head.msgType = (byte)6;
        head.cmdCode = cmdCode;
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode) {
        MSGHead head = MSGHeadBuilder.createMSGHead(cmdCode);
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryNoEMProcess(cmdCode, processInfo);
        if (0 != result) {
            logger.error("buildMSGHead() query em process failed, cmdCode = " + cmdCode);
            return null;
        }
        head.receiverProcID = processInfo.getProcID().charValue();
        head.receiverProcHandle = processInfo.getProcHandle().charValue();
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, byte receiverModule, char receiveTaskID) {
        MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode);
        if (null == head) {
            return null;
        }
        head.receiverModule = receiverModule;
        head.cmdHandle = receiveTaskID;
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, byte senderModule, char senderTaskID, byte receiverModule, char receiveTaskID) {
        MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode, receiverModule, receiveTaskID);
        if (null == head) {
            return null;
        }
        head.senderModule = senderModule;
        head.senderCmdHandle = senderTaskID;
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, ProcessInfo processInfo) {
        MSGHead head = MSGHeadBuilder.createMSGHead(cmdCode);
        head.receiverProcID = processInfo.getProcID().charValue();
        head.receiverProcHandle = processInfo.getProcHandle().charValue();
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, int neID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo);
        if (0 != result) {
            logger.error("buildMSGHead() query em process failed, cmdCode = " + cmdCode + " neID = " + neID);
            return null;
        }
        return MSGHeadBuilder.buildMSGHead(cmdCode, processInfo);
    }

    public static MSGHead buildMSGHead(int cmdCode, ProcessInfo processInfo, byte receiverModule, char receiverTaskID) {
        MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode, processInfo);
        head.receiverModule = receiverModule;
        head.cmdHandle = receiverTaskID;
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, ProcessInfo processInfo, byte senderModule, char senderTaskID, byte receiverModule, char receiveTaskID) {
        MSGHead head = MSGHeadBuilder.buildMSGHead(cmdCode, processInfo, receiverModule, receiveTaskID);
        head.senderModule = senderModule;
        head.senderCmdHandle = senderTaskID;
        return head;
    }

    public static MSGHead buildMSGHead(int cmdCode, int neID, byte receiverModule, char receiveTaskID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo);
        if (0 != result) {
            logger.error("buildMSGHead() query em process failed, cmdCode = " + cmdCode + " neID = " + neID);
            return null;
        }
        return MSGHeadBuilder.buildMSGHead(cmdCode, processInfo, receiverModule, receiveTaskID);
    }

    public static MSGHead buildMSGHead(int cmdCode, int neID, byte senderModule, char senderTaskID, byte receiverModule, char receiveTaskID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo);
        if (0 != result) {
            logger.error("buildMSGHead() query em process failed, cmdCode = " + cmdCode + " neID = " + neID);
            return null;
        }
        return MSGHeadBuilder.buildMSGHead(cmdCode, processInfo, senderModule, senderTaskID, receiverModule, receiveTaskID);
    }
}

