/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.multipkg.impl;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.communicate.util.asn.AsnCoder;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiPkgUtil {
    private static Logger logger = LoggerFactory.getLogger(MultiPkgUtil.class);

    private MultiPkgUtil() {
    }

    public static int addSubRequest(int cmdCode, int neID, FStruct request, List<MultiPkgRequest> subReqList) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo);
        if (0 != result) {
            logger.error("query EM process failed, cmdCode = " + cmdCode + " neID = " + neID);
            return result;
        }
        MultiPkgUtil.addSubRequest(processInfo, neID, request, subReqList);
        return 0;
    }

    public static void addSubRequest(ProcessInfo processInfo, int neID, FStruct request, List<MultiPkgRequest> subReqList) {
        MultiPkgRequest subReq = new MultiPkgRequest(AsnCoder.asnClone(request));
        subReq.setProcessInfo(processInfo);
        subReq.addNEID(neID);
        subReqList.add(subReq);
    }

    public static void addSubRequest(ProcessInfo processInfo, FStruct request, List<MultiPkgRequest> subReqList) {
        MultiPkgRequest subReq = new MultiPkgRequest(AsnCoder.asnClone(request));
        subReq.setProcessInfo(processInfo);
        subReqList.add(subReq);
    }

    public static void addSubRequest(List<ProcessInfo> processes, FStruct request, List<MultiPkgRequest> subReqList) {
        Iterator<ProcessInfo> iter = processes.iterator();
        while (iter.hasNext()) {
            MultiPkgUtil.addSubRequest(iter.next(), request, subReqList);
        }
    }
}

