/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.multipkg.impl;

import com.huawei.communicate.core.AppAidedMsgSyncReceiver;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiPkgOrderCommHandle
extends AbstractMultiPkgCommHandle {
    protected MultiPkgOrderCommHandle(ICommServiceAdapter commService, MSGHead msgHead, List<MultiPkgRequest> subReqList, AbstractMultiPkgReceiver receiver, int waitStrategy) {
        super(commService, msgHead, subReqList, receiver, waitStrategy);
    }

    @Override
    protected void sendRequest(final int timeout) {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            public void run() {
                int takenTime = 0;
                for (int i = 0; i < MultiPkgOrderCommHandle.this.subReqCount; ++i) {
                    MultiPkgRequest subReq = (MultiPkgRequest)MultiPkgOrderCommHandle.this.subReqList.get(i);
                    ProcessInfo processInfo = subReq.getProcessInfo();
                    ((MultiPkgOrderCommHandle)MultiPkgOrderCommHandle.this).msgHead.receiverProcID = processInfo.getProcID().charValue();
                    ((MultiPkgOrderCommHandle)MultiPkgOrderCommHandle.this).msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
                    if (timeout - takenTime > 0) {
                        long startTime = System.currentTimeMillis();
                        MultiPkgOrderCommHandle.this.sendARequest(subReq, timeout - takenTime);
                        long endTime = System.currentTimeMillis();
                        takenTime += (int)((endTime - startTime) / 1000L);
                        continue;
                    }
                    MultiPkgOrderCommHandle.this.handleToApplication(processInfo, null, -1);
                }
            }
        });
    }

    private void sendARequest(MultiPkgRequest subReq, int timeout) {
        final ProcessInfo processInfo = subReq.getProcessInfo();
        if (!processInfo.isValid()) {
            logger.warn("MultiPkgOrderCommHandle:TOMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.msgHead.cmdCode + ", msgType->ORDER");
            this.handleToApplication(processInfo, null, 3);
            return;
        }
        AppAidedMsgSyncReceiver asyncMultiRec = new AppAidedMsgSyncReceiver(){

            protected boolean processMessage(MSGPacketExt msg) {
                return MultiPkgOrderCommHandle.this.handleToApplication(processInfo, msg, CommUtil.handleErrorCode(msg.mheader.errCode));
            }

            protected int handleTimeout() {
                MultiPkgOrderCommHandle.this.handleToApplication(processInfo, null, -1);
                return -1;
            }
        };
        logger.info("MultiPkgOrderCommHandle:TOMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.msgHead.cmdCode + ", msgType->ORDER");
        int result = this.commService.sendMessage(this.msgHead, subReq.getASN1Req(), asyncMultiRec, timeout);
        if (0 != result) {
            this.handleToApplication(processInfo, null, result);
            if (null != asyncMultiRec) {
                asyncMultiRec.close();
            }
        }
    }
}

