/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.multipkg.impl;

import com.huawei.communicate.core.AppAidedMsgReceiver;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiPkgCollateralCommHandle
extends AbstractMultiPkgCommHandle {
    protected MultiPkgCollateralCommHandle(ICommServiceAdapter commService, MSGHead msgHead, List<MultiPkgRequest> subReqList, AbstractMultiPkgReceiver receiver, int waitStrategy) {
        super(commService, msgHead, subReqList, receiver, waitStrategy);
    }

    @Override
    protected void sendRequest(int timeout) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = (MultiPkgRequest)this.subReqList.get(i);
            ProcessInfo processInfo = subReq.getProcessInfo();
            this.msgHead.receiverProcID = processInfo.getProcID().charValue();
            this.msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
            this.msgHead.senderCmdHandle = '\u0000';
            if (!processInfo.isValid()) {
                logger.warn("MultiPkgCollateralCommHandle:TOMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.msgHead.cmdCode);
                this.handleToApplication(processInfo, null, 3);
                continue;
            }
            if (this.receiver == null) {
                this.sendNoResponseMessage(subReq, processInfo, timeout);
                continue;
            }
            this.sendResponseMessage(subReq, processInfo, timeout);
        }
    }

    private void sendNoResponseMessage(MultiPkgRequest subReq, ProcessInfo processInfo, int timeout) {
        logger.info("MultiPkgCollateralCommHandle:TOMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.msgHead.cmdCode + ", NOTRESPONSE");
        int result = this.commService.sendAsyncMessage(this.msgHead, subReq.getASN1Req(), null, timeout);
        if (0 != result) {
            this.exceptionHandleToApplication(processInfo, result);
        }
    }

    private void sendResponseMessage(MultiPkgRequest subReq, ProcessInfo processInfo, int timeout) {
        MultiMsgSyncReceiver asyncMultiRec = new MultiMsgSyncReceiver(processInfo);
        logger.info("MultiPkgCollateralCommHandle:TOMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.msgHead.cmdCode);
        int result = this.commService.sendAsyncMessage(this.msgHead, subReq.getASN1Req(), asyncMultiRec, timeout);
        if (0 != result) {
            this.exceptionHandleToApplication(processInfo, result);
            if (null != asyncMultiRec) {
                asyncMultiRec.close();
            }
        }
    }

    class MultiMsgSyncReceiver
    extends AppAidedMsgReceiver {
        ProcessInfo processInfo = null;

        public MultiMsgSyncReceiver(ProcessInfo process) {
            this.processInfo = process;
        }

        protected boolean processMessage(MSGPacketExt msg) {
            return MultiPkgCollateralCommHandle.this.handleToApplication(this.processInfo, msg, CommUtil.handleErrorCode(msg.mheader.errCode));
        }

        protected int handleTimeout() {
            MultiPkgCollateralCommHandle.this.handleToApplication(this.processInfo, null, -1);
            return -1;
        }

        protected boolean isDispatchInvalidPacket() {
            return true;
        }
    }
}

