/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.multipkg.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.multipkg.PkgSplitterAdapter;
import com.huawei.communicate.multipkg.impl.MultiPkgUtil;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.communicate.util.asn.AsnCoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPkgSplitter
extends PkgSplitterAdapter {
    private static final String STARDAND_NEID = "neID";
    private List neObjList;
    private String neIDName = "neID";
    private int cmdStrategy;
    private static Logger logger = LoggerFactory.getLogger(DefaultPkgSplitter.class);
    private int index = 0;
    private static final String POINT = ".";

    public DefaultPkgSplitter(List neObjList, String neIDName, int cmdStrategy) {
        if (null != neIDName) {
            this.neIDName = neIDName;
        }
        this.cmdStrategy = cmdStrategy;
        this.neObjList = neObjList;
    }

    @Override
    public List<MultiPkgRequest> getSubRequestlst(FStruct request) {
        if (null == this.neObjList) {
            logger.error("The request isn't a valid neCommand with class = " + request.getClass().getName());
            return null;
        }
        List<MultiPkgRequest> subReqList = null;
        if (this.neObjList.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("The size of the objList is 0, send the request to all the ems with procID->!" + this.msgHead.receiverProcID);
            }
            subReqList = this.getALLReqList(this.msgHead, request);
        } else {
            subReqList = 1 == this.neObjList.size() ? this.getOneReq(request) : this.dealWithMultiNEReq(this.msgHead.cmdCode, request);
        }
        if (subReqList != null) {
            logger.info("getSubRequestlst size = " + subReqList.size());
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getOneReq(FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        Object operNE = this.neObjList.get(0);
        int neID = this.getNEID(operNE);
        int result = MultiPkgUtil.addSubRequest(this.msgHead.cmdCode, neID, request, subReqList);
        if (0 != result) {
            logger.error("query EM process failed, cmdCode = " + this.msgHead.cmdCode + " neID = " + neID);
            return null;
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getALLReqList(MSGHead msgHead, FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        if ('\u0000' != msgHead.receiverProcID) {
            if ('\u0000' == msgHead.receiverProcHandle) {
                ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
                int result = ProxyUtil.queryAllEMProcess(msgHead.receiverProcID, processes);
                if (0 != result) {
                    logger.error("query EM Process failed, getALLReqList will return!");
                    return null;
                }
                MultiPkgUtil.addSubRequest(processes, request, subReqList);
            } else {
                ProcessInfo procInfo = new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle));
                MultiPkgUtil.addSubRequest(procInfo, request, subReqList);
            }
        } else {
            ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
            int result = ProxyUtil.queryAllEMProcess(msgHead.cmdCode, processes);
            if (0 != result) {
                logger.error("getALLReqList() \t query em process failed");
                return null;
            }
            MultiPkgUtil.addSubRequest(processes, request, subReqList);
        }
        return subReqList;
    }

    private List<MultiPkgRequest> dealWithMultiNEReq(int cmdcode, FStruct request) {
        List<MultiPkgRequest> subReqList = null;
        switch (this.cmdStrategy) {
            case 1: 
            case 2: {
                subReqList = this.getParallelReqlst(request);
                break;
            }
            case 0: {
                subReqList = this.getOrderReqlst(cmdcode, request);
                break;
            }
            default: {
                logger.error("dealWithMultiNEReq", (Object)("Can not support this cmdStrategy:" + this.cmdStrategy));
            }
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getParallelReqlst(FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = null;
        Map<ProcessInfo, List> proInfoMap = this.getProcInfoMap();
        if (proInfoMap.isEmpty()) {
            logger.error("getParallelReqlst() failed when getProcInfoMap()");
            return null;
        }
        subReqList = new ArrayList<MultiPkgRequest>(proInfoMap.size());
        Iterator<Map.Entry<ProcessInfo, List>> iter = proInfoMap.entrySet().iterator();
        while (iter.hasNext()) {
            this.neObjList.clear();
            Map.Entry<ProcessInfo, List> entry = iter.next();
            ProcessInfo processInfo = entry.getKey();
            List neIDLst = entry.getValue();
            MultiPkgRequest subReq = new MultiPkgRequest();
            subReq.setProcessInfo(processInfo);
            for (int i = 0; i < neIDLst.size(); ++i) {
                Object objNE = neIDLst.get(i);
                this.neObjList.add(objNE);
                subReq.addNEID(this.getNEID(objNE));
            }
            subReq.setAsnReq(AsnCoder.asnClone(request));
            subReqList.add(subReq);
        }
        return subReqList;
    }

    private List cloneNeObjList() {
        if (this.neObjList instanceof Vector) {
            return (List)((Vector)this.neObjList).clone();
        }
        if (this.neObjList instanceof ArrayList) {
            return (List)((ArrayList)this.neObjList).clone();
        }
        if (this.neObjList instanceof LinkedList) {
            return (List)((LinkedList)this.neObjList).clone();
        }
        throw new IllegalArgumentException("neObjList has a not supported type");
    }

    private List<MultiPkgRequest> getOrderReqlst(int cmdCode, FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        List neObjListExt = this.cloneNeObjList();
        Counter counter = new Counter();
        ProcessInfo cProcInfo = null;
        ArrayList tmplst = new ArrayList(10);
        int n = neObjListExt.size();
        for (int i = 0; i < n; ++i) {
            ProcessInfo processInfo;
            Object opNE = neObjListExt.get(i);
            int neID = this.getNEID(opNE);
            int result = ProxyUtil.queryEMProcess(cmdCode, neID, processInfo = new ProcessInfo());
            if (0 != result) {
                logger.error("query em process failed, cmdCode = " + cmdCode + " neID = " + neID);
                continue;
            }
            if (null != cProcInfo && !cProcInfo.equals(processInfo)) {
                this.neObjList.clear();
                processInfo.setReserved((byte)counter.counter(cProcInfo));
                this.neObjList.addAll(tmplst);
                MultiPkgUtil.addSubRequest(cProcInfo, request, subReqList);
                tmplst.clear();
                this.neObjList.clear();
            }
            tmplst.add(opNE);
            cProcInfo = processInfo;
        }
        if (!tmplst.isEmpty()) {
            this.neObjList.clear();
            cProcInfo.setReserved((byte)counter.counter(cProcInfo));
            this.neObjList.addAll(tmplst);
            MultiPkgUtil.addSubRequest(cProcInfo, request, subReqList);
            tmplst.clear();
            this.neObjList.clear();
        }
        return subReqList;
    }

    private Map<ProcessInfo, List> getProcInfoMap() {
        HashMap<ProcessInfo, List> proInfoMap = new HashMap<ProcessInfo, List>();
        int n = this.neObjList.size();
        for (int i = 0; i < n; ++i) {
            Object opNE = this.neObjList.get(i);
            ProcessInfo processInfo = new ProcessInfo();
            int result = ProxyUtil.queryEMProcess(this.msgHead.cmdCode, this.getNEID(opNE), processInfo);
            if (0 != result) {
                logger.error("query em process failed, cmdCode=" + this.msgHead.cmdCode + ",neID=" + this.getNEID(opNE));
                continue;
            }
            if (null != proInfoMap.get(processInfo)) {
                proInfoMap.get(processInfo).add(opNE);
                continue;
            }
            ArrayList neList = new ArrayList();
            neList.add(opNE);
            proInfoMap.put(processInfo, neList);
        }
        return proInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNEID(Object operationObj) {
        String tempNeID = this.neIDName;
        int neID = -1;
        if (operationObj instanceof Number) {
            neID = ((Number)operationObj).intValue();
        } else if (operationObj instanceof FStruct) {
            FStruct req = (FStruct)operationObj;
            try {
                String[] array;
                int start = tempNeID.indexOf(POINT);
                if (-1 != start && 0 != (array = tempNeID.split("\\.")).length && this.index < array.length) {
                    tempNeID = array[this.index];
                    ++this.index;
                }
                Object neIDObj = req.getClass().getField(tempNeID).get(req);
                neID = this.getNEID(neIDObj);
            }
            catch (Exception e) {
                logger.error("getNEID failed, req = " + req, (Throwable)e);
            }
            finally {
                this.index = 0;
            }
        }
        return neID;
    }

    class Counter {
        private Map<Object, Integer> counters = new HashMap<Object, Integer>();

        Counter() {
        }

        public int counter(Object obj) {
            int curCunter = 0;
            if (this.counters.containsKey(obj)) {
                int conter = this.counters.get(obj);
                this.counters.put(obj, ++conter);
            } else {
                this.counters.put(obj, curCunter++);
            }
            return curCunter;
        }
    }
}

