/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.multipkg;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgDataPacket;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiPkgCommHandle {
    protected static final long ONE_SECOND = 1000L;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMultiPkgCommHandle.class);
    public static final int SYNCHRONIZED = 0;
    public static final int ASYNCHRONIZED = 1;
    protected ICommServiceAdapter commService = null;
    protected List<MultiPkgRequest> subReqList = null;
    protected int subReqCount = 0;
    private int finishedReqCount = 0;
    protected List<MultiPkgDataPacket> rsps = null;
    private List<Counter> counters = null;
    private ProcessInfo currProcessInfo = null;
    private MSGHead currMSGHead = null;
    protected MSGHead msgHead = null;
    protected AbstractMultiPkgReceiver receiver = null;
    private List<Integer> currOperIDList = null;
    private int currCmd = -1;
    private int currDealCount = -1;
    private int waitStrategy = -1;
    private int rspStrategy = -1;
    protected int sendType = 0;
    private int timeout = 9;
    private char cmdHandle = '\u0000';

    protected AbstractMultiPkgCommHandle(ICommServiceAdapter commService, MSGHead msgHead, List<MultiPkgRequest> subReqList, AbstractMultiPkgReceiver receiver, int waitStrategy) {
        this.commService = commService;
        this.subReqList = subReqList;
        this.subReqCount = subReqList.size();
        this.receiver = receiver;
        this.rsps = new ArrayList<MultiPkgDataPacket>();
        this.currCmd = msgHead.cmdCode;
        this.setWaitStrategy(waitStrategy);
        this.setRspStrategy(this.rspStrategy);
        this.msgHead = msgHead;
        this.initCounter();
        receiver.commHandle = this;
    }

    private void initCounter() {
        this.counters = new ArrayList<Counter>(this.subReqCount);
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            Counter counter = new Counter(subReq.getProcessInfo());
            this.counters.add(counter);
        }
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public void send() {
        this.send(this.timeout);
    }

    public void send(int timeout) {
        int commTimeout = timeout;
        if (logger.isDebugEnabled()) {
            logger.debug("AbstractMultiPkgCommHandle:Start the comm with cmdCode->" + this.currCmd + ", timeout->" + commTimeout + ", reqCounts->" + this.subReqCount);
        }
        if (this.subReqCount <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("AbstractMultiPkgCommHandle:The reqList with cmdCode->" + this.currCmd + " is empty! Return directory!");
            }
            this.callMessageReceived();
            return;
        }
        if ('\u0000' != this.getCmdHandle()) {
            this.msgHead.cmdHandle = this.getCmdHandle();
        }
        if (0 != this.sendType) {
            this.msgHead.msgType = (byte)this.sendType;
        }
        this.sendRequest(commTimeout);
        if (0 == this.getWaitStrategy()) {
            this.syncWait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWait(int timeout) {
        List<Counter> list = this.counters;
        synchronized (list) {
            if (this.finishedReqCount != this.subReqCount) {
                if (logger.isDebugEnabled()) {
                    logger.debug("AbstractMultiPkgCommHandle:This is a command! wait for the receiver!");
                }
                try {
                    this.counters.wait((long)timeout * 1000L);
                }
                catch (InterruptedException ex) {
                    logger.error("AbstractMultiPkgCommHandle: wait", (Throwable)ex);
                }
            } else {
                logger.debug("AbstractMultiPkgCommHandle:Thie is a command!But the incept has finished!Don't wait!");
            }
        }
    }

    public synchronized boolean hasNextRsp() {
        if (this.hasReqUnfinished()) {
            return true;
        }
        return !this.rsps.isEmpty();
    }

    public HashMap<Integer, List<Integer>> getNEIDListMap() {
        HashMap<Integer, List<Integer>> neIDListMap = new HashMap<Integer, List<Integer>>(this.subReqCount);
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            ProcessInfo processInfo = subReq.getProcessInfo();
            int key = (processInfo.getProcID().charValue() << 16) + processInfo.getProcHandle().charValue();
            neIDListMap.put(key, subReq.getNEIDList());
        }
        return neIDListMap;
    }

    public HashMap<MSGHead, Float> getSubTaskWeightMap() {
        HashMap<MSGHead, Float> weightMap = new HashMap<MSGHead, Float>(this.subReqCount);
        boolean isNullNEReq = this.isNullNEReq();
        int totalNECount = isNullNEReq ? 0 : this.getTotalNECount();
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            ProcessInfo processInfo = subReq.getProcessInfo();
            MSGHead msgHead = new MSGHead();
            msgHead.receiverProcID = processInfo.getProcID().charValue();
            msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
            msgHead.receiverModule = processInfo.getReserved();
            float weight = isNullNEReq ? 1.0f / (float)this.subReqCount : (float)subReq.getNEIDList().size() / (float)totalNECount;
            weightMap.put(msgHead, Float.valueOf(weight));
        }
        return weightMap;
    }

    public int getCurrCount() {
        return this.currDealCount;
    }

    public int getCurrCmdCode() {
        return this.currCmd;
    }

    public MSGHead getCurrMSGHead() {
        return this.currMSGHead;
    }

    public char getCmdHandle() {
        return this.cmdHandle;
    }

    public void setCmdHandle(char cmdHandle) {
        this.cmdHandle = cmdHandle;
    }

    public List<Integer> getCurrOpIDList() {
        return this.currOperIDList;
    }

    public ProcessInfo getCurrProcessInfo() {
        return this.currProcessInfo;
    }

    public int getCurrProcID() {
        return (this.currProcessInfo.getProcID().charValue() << 16) + this.currProcessInfo.getProcHandle().charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrRsp(FStruct rsp) {
        List<MultiPkgDataPacket> list = this.rsps;
        synchronized (list) {
            while (this.rsps.isEmpty()) {
                this.waitForReceiveResponse();
            }
            MultiPkgDataPacket multiPkgData = this.rsps.remove(0);
            if (logger.isDebugEnabled()) {
                logger.debug("AbstractMultiPkgCommHandle:Receive the dataPackage from the buffer with cmdCode->" + this.currCmd + ", And the size of buffer is " + this.rsps.size());
            }
            ProcessInfo processInfo = multiPkgData.getProcessInfo();
            this.count(processInfo);
            this.recordCurrOperIDList(processInfo);
            this.currMSGHead = multiPkgData.getMSGHead();
            if (this.rsps.isEmpty() && !this.hasReqUnfinished()) {
                this.callMessageReceived();
            }
            return AbstractMultiPkgCommHandle.getASNData(multiPkgData, rsp);
        }
    }

    private void waitForReceiveResponse() {
        if (this.hasReqUnfinished()) {
            if (logger.isDebugEnabled()) {
                logger.debug("AbstractMultiPkgCommHandle:This is a command! wait for the rsps!");
            }
            try {
                this.rsps.wait();
            }
            catch (InterruptedException ex) {
                logger.error("getCurrRsp", (Throwable)ex);
            }
        }
    }

    private void count(ProcessInfo processInfo) {
        if (null != this.counters) {
            this.currProcessInfo = processInfo;
            for (int i = 0; i < this.subReqCount; ++i) {
                Counter counter = this.counters.get(i);
                if (!this.currProcessInfo.equals(counter.getProcessInfo())) continue;
                counter.addDealCounter();
                this.currDealCount = counter.getDealCounter();
                break;
            }
        }
    }

    private void recordCurrOperIDList(ProcessInfo processInfo) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (!processInfo.equals(subReq.getProcessInfo())) continue;
            this.currOperIDList = subReq.getNEIDList();
            break;
        }
    }

    public void setWaitStrategy(int waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public int getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setRspStrategy(int rspStrategy) {
        this.rspStrategy = rspStrategy;
    }

    public int getRspStrategy() {
        return this.rspStrategy;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private boolean isNullNEReq() {
        MultiPkgRequest teReq = this.subReqList.get(0);
        return teReq.getNEIDList().isEmpty();
    }

    private int getTotalNECount() {
        int totalNECount = 0;
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            totalNECount += subReq.getNEIDList().size();
        }
        return totalNECount;
    }

    private boolean hasReqUnfinished() {
        return this.finishedReqCount < this.subReqCount;
    }

    protected void setRequestFinish(ProcessInfo processInfo) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (!processInfo.equals(subReq.getProcessInfo()) || subReq.isFinish()) continue;
            subReq.setFinish(true);
            ++this.finishedReqCount;
            if (!logger.isDebugEnabled()) break;
            logger.debug("AbstractMultiPkgCommHandle:TotalReq->" + this.subReqCount + ", FinishedReq->" + this.finishedReqCount + ", cmdCode->" + this.currCmd);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveRsp(ProcessInfo processInfo, MSGPacketExt data, int result) {
        if (logger.isDebugEnabled()) {
            logger.debug("Add the package from procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode=" + this.currCmd);
        }
        List<MultiPkgDataPacket> list = this.rsps;
        synchronized (list) {
            MultiPkgDataPacket multiPkgData = new MultiPkgDataPacket();
            multiPkgData.setProcessInfo(processInfo);
            multiPkgData.setResult(result);
            multiPkgData.setData(data);
            this.rsps.add(multiPkgData);
            this.rsps.notifyAll();
        }
    }

    protected synchronized boolean handleToApplication(ProcessInfo processInfo, MSGPacketExt data, int result) {
        if (logger.isDebugEnabled()) {
            logger.debug("AbstractMultiPkgCommHandle:FROMMDP procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.currCmd + ", result->" + result);
        }
        if (null != data) {
            this.currCmd = data.mheader.cmdCode;
        }
        this.receiveRsp(processInfo, data, result);
        boolean hasFinishRec = true;
        try {
            hasFinishRec = this.receiver.checkDataIntegrity();
        }
        catch (Exception ex) {
            logger.error("invoke checkDataIntegrity() failed", (Throwable)ex);
        }
        if (hasFinishRec) {
            logger.info("AbstractMultiPkgCommHandle:The incept from procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.currCmd + " has finished!");
            this.setRequestFinish(processInfo);
            if (!this.hasReqUnfinished()) {
                this.callMessageReceived();
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("AbstractMultiPkgCommHandle:The incept from procID->" + processInfo.getProcID().charValue() + ", procHandle->" + processInfo.getProcHandle().charValue() + ", cmdCode->" + this.currCmd + " has not finished!");
        }
        return false;
    }

    private void callMessageReceived() {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug("AbstractMultiPkgCommHandle:All the incept with cmdCode->" + AbstractMultiPkgCommHandle.this.currCmd + " has finished!Call the messageReceived()");
                }
                try {
                    AbstractMultiPkgCommHandle.this.receiver.messageReceived();
                }
                catch (Exception ex) {
                    logger.error("invoke messageReceived() failed", (Throwable)ex);
                }
                List list = AbstractMultiPkgCommHandle.this.counters;
                synchronized (list) {
                    AbstractMultiPkgCommHandle.this.counters.notifyAll();
                }
            }
        });
    }

    protected void exceptionHandleToApplication(final ProcessInfo processInfo, final int reason) {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            public void run() {
                AbstractMultiPkgCommHandle.this.handleToApplication(processInfo, null, reason);
            }
        });
    }

    public static final int getASNData(MultiPkgDataPacket dataPackage, FStruct asnData) {
        if (0 != dataPackage.getResult()) {
            return dataPackage.getResult();
        }
        boolean result = AsnCoder.deserialize(dataPackage.getData(), asnData);
        if (!result) {
            dataPackage.setResult(-2);
        }
        return dataPackage.getResult();
    }

    protected abstract void sendRequest(int var1);

    private static class Counter {
        private ProcessInfo procID = null;
        private int dealCount = 0;

        Counter(ProcessInfo procID) {
            this.procID = procID;
        }

        void addDealCounter() {
            ++this.dealCount;
        }

        int getDealCounter() {
            return this.dealCount;
        }

        ProcessInfo getProcessInfo() {
            return this.procID;
        }
    }
}

