/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl.util;

import com.huawei.communicate.core.ssl.util.Crypto;
import com.huawei.communicate.core.ssl.util.DESCrypto;
import com.huawei.communicate.core.ssl.util.MaterialFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Util {
    private static Crypto theCrypto = new DESCrypto();
    private static MaterialFactory materialFactory = new MaterialFactory();
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static BASE64Decoder decoder = new BASE64Decoder();
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static String decrypt(String src, String charsetName) throws IOException {
        if (charsetName == null) {
            charsetName = DEFAULT_CHARSET;
        }
        byte[] src_bytes = Util.decodeFromBase64(src);
        byte[] dst_bytes = theCrypto.decrypt(src_bytes);
        return new String(dst_bytes, charsetName);
    }

    public static String decrypt(String src) throws IOException {
        return Util.decrypt(src, DEFAULT_CHARSET);
    }

    public static String encrypt(String src) {
        String dst = null;
        try {
            dst = Util.encrypt(src, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        return dst;
    }

    public static String encrypt(String src, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            charsetName = DEFAULT_CHARSET;
        }
        byte[] src_bytes = src.getBytes(charsetName);
        byte[] dst_bytes = theCrypto.encrypt(src_bytes);
        String base64 = Util.encodeToBase64(dst_bytes);
        return base64;
    }

    public static boolean hasContained(Certificate[] exists, Certificate toBeAdded) {
        int len = exists.length;
        for (int i = 0; i < len; ++i) {
            if (!exists[i].equals(toBeAdded)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasContained(CRL[] exists, CRL toBeAdded) {
        int len = exists.length;
        for (int i = 0; i < len; ++i) {
            if (!exists[i].equals(toBeAdded)) continue;
            return true;
        }
        return false;
    }

    public static X509Certificate[] loadCerts(String certFile) throws CertificateException, FileNotFoundException {
        Certificate[] certs = materialFactory.loadCerts(certFile);
        int len = certs.length;
        ArrayList<Certificate> x509_certs = new ArrayList<Certificate>(len);
        for (int i = 0; i < len; ++i) {
            if (!(certs[i] instanceof X509Certificate)) continue;
            x509_certs.add(certs[i]);
        }
        return x509_certs.toArray(new X509Certificate[x509_certs.size()]);
    }

    public static X509CRL[] loadCRLs(String crlFile) throws FileNotFoundException, CertificateException, CRLException {
        CRL[] crls = materialFactory.loadCRLs(crlFile);
        int len = crls.length;
        ArrayList<CRL> x509_crls = new ArrayList<CRL>(len);
        for (int i = 0; i < len; ++i) {
            if (!(crls[i] instanceof X509CRL)) continue;
            x509_crls.add(crls[i]);
        }
        return x509_crls.toArray(new X509CRL[x509_crls.size()]);
    }

    public static boolean storeCerts(Certificate[] certs, String destination) throws CertificateEncodingException, IOException {
        boolean ret = materialFactory.storeCerts(certs, destination);
        return ret;
    }

    public static boolean storeCRLs(CRL[] crls, String destination) throws CRLException, IOException {
        boolean ret = materialFactory.storeCRLs(crls, destination);
        return ret;
    }

    public static boolean verifyKeyStore(String keystoreFile, char[] storePassword, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        materialFactory.loadKeyStore(keystoreFile, storePassword, keystoreType);
        return true;
    }

    public static boolean verifyPrivateKey(String keystoreFile, char[] storePassword, char[] keyPassword, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore ks = materialFactory.loadKeyStore(keystoreFile, storePassword, keystoreType);
        Enumeration<String> e = ks.aliases();
        String alias = null;
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            ks.getKey(alias, keyPassword);
            return true;
        }
        return false;
    }

    static String encodeToBase64(byte[] encode) {
        return encoder.encode(encode);
    }

    private static byte[] decodeFromBase64(String base64) throws IOException {
        return decoder.decodeBuffer(base64);
    }
}

