/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl.util;

import com.huawei.communicate.core.ssl.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialFactory {
    private static Logger logger = LoggerFactory.getLogger(MaterialFactory.class);
    private final String lineSeparator = System.getProperty("line.separator");
    private static final String x509CRLBegin = "-----BEGIN X509 CRL-----";
    private static final String x509CRLEnd = "-----END X509 CRL-----";
    private static final String x509CertBegin = "-----BEGIN CERTIFICATE-----";
    private static final String x509CertEnd = "-----END CERTIFICATE-----";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRL[] loadCRLs(String CRLFile) throws FileNotFoundException, CertificateException, CRLException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(CRLFile);
            CRL[] cRLArray = this.loadCRLs(fin);
            return cRLArray;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public CRL[] loadCRLs(InputStream stream) throws CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends CRL> c = cf.generateCRLs(stream);
        CRL[] crls = c.toArray(new CRL[c.size()]);
        return crls;
    }

    public boolean storeCRLs(CRL[] crls, OutputStream outStream) throws CRLException, IOException {
        if (crls == null) {
            return false;
        }
        int len = crls.length;
        for (int i = 0; i < len; ++i) {
            byte[] pem = this.getPEMCRL(crls[i]);
            outStream.write(pem);
        }
        outStream.flush();
        return true;
    }

    private byte[] getPEMCRL(CRL crl) throws CRLException {
        if (!(crl instanceof X509CRL)) {
            throw new CRLException("Unsupported CRL type: " + crl.getType());
        }
        X509CRL x509crl = (X509CRL)crl;
        byte[] encode = x509crl.getEncoded();
        String base64 = Util.encodeToBase64(encode);
        StringBuffer str_crl = new StringBuffer();
        str_crl.append(x509CRLBegin);
        str_crl.append(this.lineSeparator);
        str_crl.append(base64);
        str_crl.append(this.lineSeparator);
        str_crl.append(x509CRLEnd);
        str_crl.append(this.lineSeparator);
        return str_crl.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeCRLs(CRL[] crls, String destination) throws CRLException, IOException {
        if (crls == null) {
            return false;
        }
        boolean succeed = false;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(destination);
            succeed = this.storeCRLs(crls, outStream);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ioex) {
                    logger.error("", (Throwable)ioex);
                }
            }
        }
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(String keystoreFile, char[] storePass, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(keystoreFile);
            KeyStore keyStore = this.loadKeyStore(fin, storePass, keystoreType);
            return keyStore;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public KeyStore loadKeyStore(InputStream keystoreStream, char[] storePass, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(keystoreType);
        ks.load(keystoreStream, storePass);
        return ks;
    }

    private KeyStore buildEmptyKeyStore(String type) throws KeyStoreException {
        KeyStore ks = KeyStore.getInstance(type);
        try {
            ks.load(null, null);
        }
        catch (GeneralSecurityException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return ks;
    }

    public KeyStore loadKeyStore(List trustCerts, String type) throws KeyStoreException {
        KeyStore ks = this.buildEmptyKeyStore(type);
        int serial_id = 0;
        String alias = "TrustCertAlias_";
        Certificate cert2 = null;
        for (Certificate cert2 : trustCerts) {
            ks.setCertificateEntry(alias + ++serial_id, cert2);
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] loadCerts(String trustCerFile) throws CertificateException, FileNotFoundException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(trustCerFile);
            Certificate[] certificateArray = this.loadCerts(fin);
            return certificateArray;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public Certificate[] loadCerts(InputStream stream) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> cers = cf.generateCertificates(stream);
        Certificate[] certs = cers.toArray(new Certificate[cers.size()]);
        return certs;
    }

    public boolean storeCerts(Certificate[] certs, OutputStream outStream) throws CertificateEncodingException, IOException {
        if (certs == null) {
            return false;
        }
        int len = certs.length;
        for (int i = 0; i < len; ++i) {
            byte[] pem = this.getPEMCert(certs[i]);
            outStream.write(pem);
        }
        outStream.flush();
        return true;
    }

    private byte[] getPEMCert(Certificate certificate) throws CertificateEncodingException {
        byte[] encode = certificate.getEncoded();
        String base64 = Util.encodeToBase64(encode);
        StringBuffer str_cert = new StringBuffer();
        str_cert.append(x509CertBegin);
        str_cert.append(this.lineSeparator);
        str_cert.append(base64);
        str_cert.append(this.lineSeparator);
        str_cert.append(x509CertEnd);
        str_cert.append(this.lineSeparator);
        return str_cert.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeCerts(Certificate[] certs, String destination) throws CertificateEncodingException, IOException {
        if (certs == null) {
            return false;
        }
        boolean succeed = false;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(destination);
            succeed = this.storeCerts(certs, outStream);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return succeed;
    }
}

