/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl.util;

import com.huawei.communicate.core.ssl.util.Crypto;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DESCrypto
implements Crypto {
    private byte[] keyBytes = new byte[]{104, 22, -89, 4, 103, 31, 61, 121};
    private Key key = null;
    private Cipher cipher = null;
    private static Logger logger = LoggerFactory.getLogger(DESCrypto.class);

    public DESCrypto() {
        try {
            this.cipher = Cipher.getInstance("DES");
            this.setKeyBytes(this.keyBytes);
        }
        catch (GeneralSecurityException e) {
            logger.error("", (Throwable)e);
        }
    }

    public DESCrypto(byte[] keyBytes) {
        this();
        try {
            this.setKeyBytes(keyBytes);
        }
        catch (GeneralSecurityException e) {
            logger.error("", (Throwable)e);
        }
    }

    private void setKeyBytes(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        this.keyBytes = keyBytes;
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
        DESKeySpec des_spec = new DESKeySpec(this.keyBytes);
        this.key = kf.generateSecret(des_spec);
    }

    public byte[] encrypt(byte[] src) {
        try {
            this.cipher.init(1, this.key);
            return this.cipher.doFinal(src);
        }
        catch (GeneralSecurityException e) {
            logger.error("", (Throwable)e);
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] src) {
        try {
            this.cipher.init(2, this.key);
            return this.cipher.doFinal(src);
        }
        catch (GeneralSecurityException e) {
            logger.error("", (Throwable)e);
            return new byte[0];
        }
    }
}

