/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl.util;

import com.huawei.communicate.core.ssl.util.CommStyleInfo;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CommStyleManager {
    private static Logger logger = LoggerFactory.getLogger(CommStyleManager.class);
    private static CommStyleManager instance = new CommStyleManager();

    private CommStyleManager() {
    }

    public static CommStyleManager getInstance() {
        return instance;
    }

    public CommStyleInfo getAbsCommStyleFile(String configFile) {
        File conFile = new File(configFile);
        String absolutPath = conFile.getAbsolutePath();
        if (!conFile.exists()) {
            logger.error("File not fount," + absolutPath);
            return null;
        }
        CommStyleInfo commStyleInfo = null;
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(absolutPath);
            Element rootEllement = doc.getDocumentElement();
            commStyleInfo = CommStyleInfo.unmarshal(rootEllement);
        }
        catch (Exception e) {
            logger.error("getAbsCommStyleFile() fail!" + e);
        }
        return commStyleInfo;
    }
}

