/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.CRLInvalidException;
import com.huawei.communicate.core.ssl.CertRevokedException;
import com.huawei.communicate.core.ssl.X509TrustManagerWrapper;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerCRL
extends X509TrustManagerWrapper {
    private CRL[] peerCRL = null;

    public X509TrustManagerCRL(X509TrustManager trustManager) {
        super(trustManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkServerTrusted(X509Certificate[] cerChain, String authType) throws CertificateException {
        if (!this.authPeer()) {
            return;
        }
        super.checkServerTrusted(cerChain, authType);
        if (this.peerCRL == null) return;
        int cert_len = cerChain.length;
        String cert_issuer_name = null;
        ArrayList<String> col = new ArrayList<String>(cert_len);
        X509CRLSelector crlsel = new X509CRLSelector();
        int crl_len = this.peerCRL.length;
        if (crl_len <= 0) return;
        for (int i = 0; i < cert_len; ++i) {
            cert_issuer_name = cerChain[i].getIssuerX500Principal().getName();
            col.clear();
            col.add(cert_issuer_name);
            try {
                crlsel.setIssuerNames(col);
            }
            catch (IOException e) {
                CRLInvalidException ex = new CRLInvalidException("No CRL is available. Pleaes update the CRL.");
                ex.initCause(e);
                throw ex;
            }
            CRL[] valid_crls = this.filterCRL(crlsel);
            if (valid_crls == null || valid_crls.length == 0) {
                throw new CRLInvalidException("No CRL is available. Pleaes update the CRL.");
            }
            for (int j = 0; j < valid_crls.length; ++j) {
                this.validateCert(valid_crls[j], cerChain[i]);
            }
        }
    }

    private void validateCert(CRL crl, X509Certificate cerChain) throws CertRevokedException {
        boolean isRevoked = crl.isRevoked(cerChain);
        if (isRevoked) {
            throw new CertRevokedException("Peer's certificate has revoked.");
        }
    }

    public void setCRLs(CRL[] crl) {
        this.peerCRL = crl;
    }

    private CRL[] filterCRL(X509CRLSelector crlsel) throws CertificateException {
        int crl_len = this.peerCRL.length;
        ArrayList<X509CRL> tempcrl = new ArrayList<X509CRL>(crl_len);
        X509CRL xcrl = null;
        Date current_date = new Date(System.currentTimeMillis());
        for (int i = 0; i < crl_len; ++i) {
            if (!crlsel.match(this.peerCRL[i]) || !current_date.before((xcrl = (X509CRL)this.peerCRL[i]).getNextUpdate())) continue;
            tempcrl.add(xcrl);
        }
        return tempcrl.toArray(new CRL[tempcrl.size()]);
    }
}

