/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.X509TrustManagerCRL;
import com.huawei.communicate.core.ssl.X509TrustManagerWrapper;
import com.huawei.communicate.core.ssl.util.MaterialFactory;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustMaterial {
    private List peerCRLs = new ArrayList(16);
    private static final int CRL_SIZE = 16;
    private List trustCerts = new ArrayList(16);
    private static final int CERT_SIZE = 16;
    private boolean bAuthPeer = true;
    private MaterialFactory theMaterialBuilder = new MaterialFactory();

    public void setAuthPeer(boolean authPeer) {
        this.bAuthPeer = authPeer;
    }

    public boolean authPeer() {
        return this.bAuthPeer;
    }

    public void addCRL(CRL crl) {
        this.peerCRLs.add(crl);
    }

    public void addCRL(String CRLFile) throws FileNotFoundException, CertificateException, CRLException {
        CRL[] crls = this.theMaterialBuilder.loadCRLs(CRLFile);
        if (crls != null) {
            int size = crls.length;
            for (int i = 0; i < size; ++i) {
                this.peerCRLs.add(crls[i]);
            }
        }
    }

    public void addTrustCert(Certificate cert) {
        this.trustCerts.add(cert);
    }

    public void addTrustCert(String certFile) throws CertificateException, FileNotFoundException {
        Certificate[] certs = this.theMaterialBuilder.loadCerts(certFile);
        if (certs != null) {
            int size = certs.length;
            for (int i = 0; i < size; ++i) {
                this.trustCerts.add(certs[i]);
            }
        }
    }

    protected KeyStore getKeyStore() throws KeyStoreException {
        KeyStore ks = null;
        try {
            ks = this.theMaterialBuilder.loadKeyStore(this.trustCerts, "JKS");
        }
        catch (KeyStoreException e) {
            return null;
        }
        return ks;
    }

    public TrustManager[] getTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = this.getKeyStore();
        TrustManagerFactory tmf = null;
        tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(trustStore);
        return this.getWrappedTrustManagers(tmf.getTrustManagers());
    }

    private TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        CRL[] crls = this.peerCRLs.toArray(new CRL[this.peerCRLs.size()]);
        int len = tms.length;
        TrustManager[] crlTMs = new X509TrustManagerCRL[len];
        for (int i = 0; i < len; ++i) {
            crlTMs[i] = new X509TrustManagerCRL((X509TrustManager)tms[i]);
            ((X509TrustManagerCRL)crlTMs[i]).setCRLs(crls);
            ((X509TrustManagerWrapper)crlTMs[i]).setAuthPeer(this.bAuthPeer);
        }
        return crlTMs;
    }
}

