/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.SSLSocketFactoryWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryCustomized
extends SSLSocketFactoryWrapper {
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;

    public SSLSocketFactoryCustomized(SSLSocketFactory factory) {
        super(factory);
    }

    public void setEnabledCipherSuite(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public Socket createSocket(String arg0, int arg1) throws IOException {
        Socket s = super.createSocket(arg0, arg1);
        this.decorate(s);
        return s;
    }

    public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
        Socket s = super.createSocket(arg0, arg1, arg2, arg3);
        this.decorate(s);
        return s;
    }

    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        Socket s = super.createSocket(arg0, arg1);
        this.decorate(s);
        return s;
    }

    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        Socket s = super.createSocket(arg0, arg1, arg2, arg3);
        this.decorate(s);
        return s;
    }

    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        Socket s = super.createSocket(arg0, arg1, arg2, arg3);
        this.decorate(s);
        return s;
    }

    private void decorate(Socket s) {
        if (s instanceof SSLSocket) {
            SSLSocket ssls = (SSLSocket)s;
            if (this.enabledCipherSuites != null) {
                ssls.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                ssls.setEnabledProtocols(this.enabledProtocols);
            }
            ssls.setUseClientMode(true);
        }
    }
}

