/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.util.MaterialFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.LoggerFactory;

public class KeyMaterial {
    private KeyStore keystore = null;
    private char[] keypass = null;
    private MaterialFactory theMaterialBuilder = new MaterialFactory();

    public KeyMaterial() {
    }

    public KeyMaterial(InputStream stream, char[] storePass, char[] keyPass, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keystore = this.theMaterialBuilder.loadKeyStore(stream, storePass, keystoreType);
        this.keypass = keyPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyMaterial(String keystoreFile, char[] storePass, char[] keyPass, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(keystoreFile);
            this.keystore = this.theMaterialBuilder.loadKeyStore(fin, storePass, keystoreType);
            this.keypass = keyPass;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioex) {
                    LoggerFactory.getLogger(KeyMaterial.class).info("Close FileInputStream error.", (Throwable)ioex);
                }
            }
        }
    }

    public KeyMaterial(KeyStore keystore, char[] keyPass) {
        this.keystore = keystore;
        this.keypass = keyPass;
    }

    public KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmf = null;
        kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(this.keystore, this.keypass);
        return kmf.getKeyManagers();
    }
}

