/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.Configurator;
import com.huawei.communicate.core.ssl.KeyMaterial;
import com.huawei.communicate.core.ssl.NoSuchProtocolVersionException;
import com.huawei.communicate.core.ssl.NoTrustCertException;
import com.huawei.communicate.core.ssl.Option;
import com.huawei.communicate.core.ssl.SSL;
import com.huawei.communicate.core.ssl.SSLIntializtionException;
import com.huawei.communicate.core.ssl.TrustMaterial;
import com.huawei.communicate.core.ssl.TrustStoreException;
import com.huawei.communicate.core.ssl.util.CipherMapping;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static Logger logger = LoggerFactory.getLogger(Context.class);
    private SSL theSSL = new SSL();
    private Configurator configurator = null;

    public static SSLContext createSSLContext(String idCert, String storeType, char[] pfxPwd, char[] keyPwd, String trustCert, String crl, String protVersion, String[] cipherSuites, boolean authPeer) throws SSLIntializtionException {
        KeyMaterial km = null;
        try {
            km = new KeyMaterial(idCert, pfxPwd, keyPwd, storeType);
        }
        catch (FileNotFoundException e) {
            logger.info("", (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new SSLIntializtionException(e.getMessage(), 1, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLIntializtionException(e.getMessage(), 1, e);
        }
        catch (CertificateException e) {
            throw new SSLIntializtionException(e.getMessage(), 1, e);
        }
        catch (IOException e) {
            throw new SSLIntializtionException(e.getMessage(), 2, e);
        }
        TrustMaterial tm = new TrustMaterial();
        try {
            tm.addTrustCert(trustCert);
        }
        catch (CertificateException e) {
            throw new SSLIntializtionException(e.getMessage(), 4, e);
        }
        catch (FileNotFoundException e) {
            logger.info("", (Throwable)e);
        }
        try {
            tm.addCRL(crl);
        }
        catch (FileNotFoundException e) {
            logger.info("", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new SSLIntializtionException(e.getMessage(), 7, e);
        }
        catch (CRLException e) {
            throw new SSLIntializtionException(e.getMessage(), 8, e);
        }
        Context context = new Context();
        context.addKeyMaterial(km);
        context.addTrustMaterial(tm);
        context.setAuthPeer(authPeer);
        if (protVersion == null || "".equals(protVersion)) {
            protVersion = "TLSv1";
        }
        context.setEnabledProtocolVersion(protVersion);
        context.setEnabledCipherSuites(cipherSuites);
        SSLContext sslcontext = null;
        try {
            sslcontext = context.createSSLContext();
        }
        catch (KeyManagementException e) {
            throw new SSLIntializtionException(e.getMessage(), 9, e);
        }
        catch (KeyStoreException e) {
            throw new SSLIntializtionException(e.getMessage(), 9, e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SSLIntializtionException(e.getMessage(), 10, e);
        }
        catch (NoSuchProtocolVersionException e) {
            throw new SSLIntializtionException(e.getMessage(), 12, e);
        }
        catch (TrustStoreException e) {
            throw new SSLIntializtionException(e.getMessage(), 11, e);
        }
        return sslcontext;
    }

    public SSLContext createSSLContext() throws NoSuchProtocolVersionException, KeyManagementException, KeyStoreException, UnrecoverableKeyException, TrustStoreException {
        return this.theSSL.createSSLContext();
    }

    public void setConfigurator(Configurator config) {
        this.configurator = config;
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setAuthPeer(boolean authPeer) {
        this.theSSL.setAuthPeer(authPeer);
    }

    public boolean authPeer() {
        return this.theSSL.authPeer();
    }

    public String[] setEnabledCipherSuites(String[] cipherSuites) {
        return this.theSSL.setEnabledCipherSuites(cipherSuites);
    }

    public String[] getEnabledCipherSuites() {
        return this.theSSL.getEnabledCipherSuites();
    }

    public String setEnabledProtocolVersion(String ver) {
        return this.theSSL.setEnabledProtocolVersion(ver);
    }

    public String getEnabledProtocolVersion() {
        return this.theSSL.getEnabledProtocolVersion();
    }

    public void addKeyMaterial(KeyMaterial keyMaterial) {
        this.theSSL.addKeyMaterial(keyMaterial);
    }

    public void addTrustMaterial(TrustMaterial trustMaterial) {
        this.theSSL.addTrustMaterial(trustMaterial);
    }

    public void init(Configurator config) throws SSLIntializtionException {
        String keystore_file = config.getKeyStore();
        String keystore_type = config.getKeyStroeType();
        char[] store_pwd = config.getStorePassword();
        char[] key_pwd = config.getKeyPassword();
        String trust_cert_file = config.getTrustCert();
        String crl_file = config.getCRL();
        KeyMaterial km = null;
        TrustMaterial tm = null;
        if (keystore_file != null && !"".equals(keystore_file)) {
            try {
                km = new KeyMaterial(keystore_file, store_pwd, key_pwd, keystore_type);
            }
            catch (KeyStoreException e) {
                throw new SSLIntializtionException(e.getMessage(), 1, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLIntializtionException(e.getMessage(), 1, e);
            }
            catch (CertificateException e) {
                throw new SSLIntializtionException(e.getMessage(), 1, e);
            }
            catch (FileNotFoundException e) {
                logger.info("", (Throwable)e);
            }
            catch (IOException e) {
                throw new SSLIntializtionException(e.getMessage(), 2, e);
            }
        }
        if (trust_cert_file != null && !"".equals(trust_cert_file)) {
            tm = new TrustMaterial();
            try {
                tm.addTrustCert(trust_cert_file);
            }
            catch (CertificateException e) {
                throw new SSLIntializtionException(e.getMessage(), 4, e);
            }
            catch (FileNotFoundException e) {
                logger.info("", (Throwable)e);
            }
            if (crl_file != null && !"".equals(crl_file)) {
                try {
                    tm.addCRL(crl_file);
                }
                catch (FileNotFoundException e) {
                    logger.info("", (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new SSLIntializtionException(e.getMessage(), 7, e);
                }
                catch (CRLException e) {
                    throw new SSLIntializtionException(e.getMessage(), 8, e);
                }
            }
        }
        this.addKeyMaterial(km);
        this.addTrustMaterial(tm);
        Option option = config.getOption();
        if (option != null) {
            boolean auth_peer = option.isEnableAuthPeer();
            String version = option.getVersion();
            String encrypt_level = option.getEncryptLevel();
            this.theSSL.setAuthPeer(auth_peer);
            this.theSSL.setEnabledProtocolVersion(version);
            this.theSSL.setEnabledCipherSuites(CipherMapping.getCipherList(encrypt_level));
        }
    }

    public SocketFactory createSocketFactory() throws SSLIntializtionException {
        try {
            return this.theSSL.createSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new SSLIntializtionException(e.getMessage(), 9, e);
        }
        catch (KeyStoreException e) {
            throw new SSLIntializtionException(e.getMessage(), 9, e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SSLIntializtionException(e.getMessage(), 10, e);
        }
        catch (NoSuchProtocolVersionException e) {
            throw new SSLIntializtionException(e.getMessage(), 12, e);
        }
        catch (TrustStoreException e) {
            throw new SSLIntializtionException(e.getMessage(), 11, e);
        }
        catch (NoTrustCertException e) {
            throw new SSLIntializtionException(e.getMessage(), 11, e);
        }
    }
}

