/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.ssl;

import com.huawei.communicate.core.ssl.ConfigurationChangedListener;
import com.huawei.communicate.core.ssl.Option;
import com.huawei.communicate.core.ssl.util.AreaDescContainer;
import com.huawei.communicate.core.ssl.util.CommStyleInfo;
import com.huawei.communicate.core.ssl.util.CommStyleManager;
import com.huawei.communicate.core.ssl.util.DescContainer;
import com.huawei.communicate.core.ssl.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Configurator {
    private String configPath = "";
    private CommStyleInfo commStyleFile = null;
    private AreaDescContainer sslConfig = null;
    private static final String sslConfigFileName = "certificateConfig.xml";
    private final Object confMutext = new Object();
    private List confListeners = null;
    private Option option = null;

    public Configurator(String path) {
        boolean succeed = this.setConfigPath(path);
        if (!succeed) {
            StringBuffer msg = new StringBuffer();
            msg.append(path);
            msg.append(File.separator);
            msg.append(sslConfigFileName);
            msg.append(" is not exist or not well formed.");
            throw new IllegalArgumentException(msg.toString());
        }
        String sslRootPath = this.getValue("sslRootPath", "path");
        this.configPath = new File(path).getAbsolutePath();
        if (sslRootPath != null) {
            File file = new File(sslRootPath);
            this.configPath = file.isAbsolute() ? file.getAbsolutePath() : this.configPath + File.separator + sslRootPath;
        }
        this.confListeners = new ArrayList();
        this.option = null;
    }

    public Configurator(String path, String optionFile) {
        this(path);
        String optionpath = this.getConfigPath();
        this.option = new Option(optionpath + File.separator + optionFile);
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public Option getOption() {
        return this.option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfigurationListener(ConfigurationChangedListener listener) {
        Object object = this.confMutext;
        synchronized (object) {
            if (!this.confListeners.contains(listener)) {
                return this.confListeners.add(listener);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigurationListener(ConfigurationChangedListener listener) {
        Object object = this.confMutext;
        synchronized (object) {
            return this.confListeners.remove(listener);
        }
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCRL() {
        String file_name = this.getValue("crl", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String type = this.getValue("crl", "type");
        if (null == type) {
            type = "";
        }
        StringBuilder path = new StringBuilder();
        path.append(this.configPath).append(File.separator).append("crl").append(File.separator).append(type).append(File.separator).append(file_name);
        return path.toString();
    }

    public char[] getKeyPassword() {
        String encrypted_pwd = this.getValue("keyStore", "keyPassword");
        if (encrypted_pwd == null) {
            return null;
        }
        try {
            String decrypted_pwd = Util.decrypt(encrypted_pwd);
            return decrypted_pwd.toCharArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getKeyStore() {
        String file_name = this.getValue("keyStore", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String type = this.getValue("keyStore", "type");
        if (null == type) {
            type = "";
        }
        StringBuilder path = new StringBuilder();
        path.append(this.configPath).append(File.separator).append("keyStore").append(File.separator).append(type).append(File.separator).append(file_name);
        return path.toString();
    }

    public String getKeyStroeType() {
        String keyStoreType = this.getValue("keyStore", "type");
        return Configurator.convertKeyStoreType(keyStoreType);
    }

    private static String convertKeyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            keyStoreType = "PFX".equals(keyStoreType) ? "pkcs12" : keyStoreType;
        }
        return keyStoreType;
    }

    public char[] getStorePassword() {
        String encrypted_pwd = this.getValue("keyStore", "storePassword");
        if (encrypted_pwd == null) {
            return null;
        }
        try {
            String decrypted_pwd = Util.decrypt(encrypted_pwd);
            return decrypted_pwd.toCharArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getTrustCert() {
        String file_name = this.getValue("trust", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String type = this.getValue("trust", "type");
        if (null == type) {
            type = "";
        }
        StringBuilder path = new StringBuilder();
        path.append(this.configPath).append(File.separator).append("trust").append(File.separator).append(type).append(File.separator).append(file_name);
        return path.toString();
    }

    public String getValue(String item, String name) {
        DescContainer desc = this.sslConfig.getDescContainer(item);
        if (desc == null) {
            return null;
        }
        return desc.getParasItemValue(name);
    }

    private boolean readFrom(String configFile) {
        this.commStyleFile = CommStyleManager.getInstance().getAbsCommStyleFile(configFile);
        if (this.commStyleFile == null) {
            return false;
        }
        this.sslConfig = this.commStyleFile.getAreaDescContainer("ssl");
        return this.sslConfig != null;
    }

    private boolean setConfigPath(String configPath) {
        if (configPath == null) {
            return false;
        }
        this.configPath = configPath;
        File certConfFile = new File(this.configPath);
        this.configPath = certConfFile.getAbsolutePath();
        certConfFile = new File(this.configPath);
        if (!certConfFile.exists()) {
            return false;
        }
        return this.readFrom(this.configPath + File.separator + sslConfigFileName);
    }
}

