/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core.info;

public class ProcessInfo {
    private static final char INVALID = '\uffff';
    private String name;
    private Character procID = Character.valueOf('\uffff');
    private Character procHandle = Character.valueOf('\u0000');
    private byte reserved = 0;

    public ProcessInfo() {
    }

    public ProcessInfo(char procID, char procHandle, String name) throws NullPointerException {
        this(Character.valueOf(procID), Character.valueOf(procHandle));
        this.name = name;
    }

    public ProcessInfo(Character procID, Character procHandle) throws NullPointerException {
        if (null == procID && null == procHandle) {
            throw new IllegalArgumentException("Both procID and procHandle are null.");
        }
        this.procID = procID;
        this.procHandle = procHandle;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte reserved) {
        this.reserved = reserved;
    }

    public String getName() {
        return this.name;
    }

    public Character getProcID() {
        return this.procID;
    }

    public Character getProcHandle() {
        return this.procHandle;
    }

    public void setProcID(char procID) {
        this.procID = Character.valueOf(procID);
    }

    public void setProcHandle(char procHandle) {
        this.procHandle = Character.valueOf(procHandle);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProcessInfo) {
            ProcessInfo that = (ProcessInfo)obj;
            return ProcessInfo.equals(this.procID, that.procID) && ProcessInfo.equals(this.procHandle, that.procHandle);
        }
        return false;
    }

    private static boolean equals(Character a, Character b) {
        return null == a ? null == b : a.equals(b);
    }

    private static int intValue(Character v) {
        return null == v ? (char)'\u0000' : v.charValue();
    }

    public int hashCode() {
        int shiftProcID = ProcessInfo.intValue(this.procID) << 16;
        int intProcHandle = ProcessInfo.intValue(this.procHandle);
        return shiftProcID | intProcHandle;
    }

    public String toString() {
        return "(procID = " + ProcessInfo.getString(this.procID) + " procHandle = " + ProcessInfo.getString(this.procHandle) + ")";
    }

    static String getString(Character value) {
        return null == value ? "null" : String.valueOf((int)value.charValue());
    }

    public boolean isValid() {
        return this.procID.charValue() != '\uffff' && this.procHandle.charValue() != '\uffff';
    }

    public void resetProcessInfo(ProcessInfo procInfo) {
        this.procID = procInfo.procID;
        this.procHandle = procInfo.procHandle;
    }
}

