/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommUtil;
import java.util.StringTokenizer;

class Sock5Request {
    public static final int DATA_LEN = 10;
    private static final int IP_LEN = 4;
    public byte version = (byte)5;
    public byte command = 1;
    public byte reserved = 0;
    public byte atype = 1;
    public String remoteIp = null;
    public short port;
    public static final int SOCK5_CONNECT_SUCCESS = 0;

    Sock5Request() {
    }

    public byte[] toByte() throws IllegalArgumentException {
        byte[] data = new byte[10];
        data[0] = this.version;
        data[1] = this.command;
        data[2] = this.reserved;
        data[3] = this.atype;
        byte[] bytes = this.iptoByte(this.remoteIp);
        System.arraycopy(bytes, 0, data, 4, 4);
        bytes = CommUtil.charToBytes((char)this.port);
        System.arraycopy(bytes, 0, data, 8, 2);
        return data;
    }

    public byte[] iptoByte(String IP) throws IllegalArgumentException {
        byte[] bytes = new byte[4];
        StringTokenizer strToken = new StringTokenizer(IP, ".");
        if (strToken.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid IP address:" + IP);
        }
        int i = 0;
        while (strToken.hasMoreTokens()) {
            short value = Short.parseShort((String)strToken.nextElement());
            bytes[i] = CommUtil.charToUnsignedByte((char)value);
            ++i;
        }
        return bytes;
    }

    public void fromByte(byte[] data) throws IllegalArgumentException {
        if (data.length < 10) {
            throw new IllegalArgumentException("invalid response data: " + new String(data));
        }
        this.version = data[0];
        this.command = data[1];
        this.reserved = data[2];
        this.atype = data[3];
    }
}

