/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConnector {
    private static Logger logger = LoggerFactory.getLogger(SSLConnector.class);
    private SSLSocketFactory socketFactory = null;

    public void setSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    Socket createSSLSocket(String host, int port) {
        if (null != this.socketFactory) {
            try {
                logger.info("Creating Socket from business moduleFactory implemention");
                return this.socketFactory.createSocket(host, port);
            }
            catch (UnknownHostException e) {
                logger.error("Not able to connect to Host: " + host + " Port:" + port, (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IOError: Host " + host + " Port " + port, (Throwable)e);
            }
            logger.error("Creating Socket from business moduleFactory implemention Failed");
            return null;
        }
        logger.error("SocketFactory is NULL.");
        return null;
    }
}

