/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommStateEvent;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reconnector {
    private static Logger logger = LoggerFactory.getLogger(Reconnector.class);
    public static final int MAX_INTERVAL = 30;
    public static final int MAX_TIMES = 100000;
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMES = Integer.MAX_VALUE;
    protected int ninterval = 1;
    protected int maxtimes = Integer.MAX_VALUE;
    private static final long ONE_SECOND = 1000L;

    public Reconnector(Properties props) {
        String s_maxtimes;
        String s_inter = props.getProperty("interval");
        if (s_inter != null) {
            try {
                this.ninterval = Integer.parseInt(s_inter);
                this.ninterval = this.ninterval > 30 || this.ninterval < 1 ? 1 : this.ninterval;
            }
            catch (NumberFormatException e) {
                this.ninterval = 1;
                logger.warn("Reconnector()", (Throwable)e);
            }
        }
        if ((s_maxtimes = props.getProperty("maxtimes")) != null) {
            try {
                this.maxtimes = Integer.parseInt(s_maxtimes);
                this.maxtimes = this.maxtimes > 100000 || this.maxtimes < 1 ? Integer.MAX_VALUE : this.maxtimes;
            }
            catch (NumberFormatException e) {
                this.maxtimes = Integer.MAX_VALUE;
                logger.warn("Reconnector()", (Throwable)e);
            }
        }
    }

    public boolean reconnect(CommHandle consumer) {
        int p_retry = 0;
        try {
            while (!consumer.isClosed()) {
                consumer.stateChanged(CommStateEvent.RECONNECT_RUN);
                ++p_retry;
                if (consumer.reconnect()) {
                    consumer.stateChanged(CommStateEvent.RECONNECT_SUCCESS);
                    return true;
                }
                consumer.stateChanged(CommStateEvent.RECONNECT_FAILED);
                if (!this.isContinue(p_retry)) {
                    consumer.stateChanged(CommStateEvent.RECONNECT_ABORT);
                    return false;
                }
                int interval = p_retry * this.ninterval;
                if (interval > 30) {
                    interval = 30;
                }
                consumer.stateChanged(CommStateEvent.RECONNECT_WAIT);
                Thread.sleep((long)interval * 1000L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("reconnect()", (Throwable)e);
        }
        consumer.stateChanged(CommStateEvent.RECONNECT_EXIT);
        return false;
    }

    protected boolean isContinue(int retrys) {
        return retrys < this.maxtimes;
    }
}

