/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.AppAidedMsgListener;
import com.huawei.communicate.core.AppAidedMsgSyncReceiver;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommTimeoutChecker;
import com.huawei.communicate.core.DataAccepter;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.core.UnknownCommandReceiver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MsgDispatcher
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(MsgDispatcher.class);
    private volatile boolean running = true;
    private CommHandle m_Handle = null;
    private DataAccepter accepter = null;
    private CommTimeoutChecker checker = null;
    private Hashtable listenTable = new Hashtable();
    private ConcurrentHashMap receivers = new ConcurrentHashMap();
    private UnknownCommandReceiver unknownCommReceiver;
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    MsgDispatcher(CommHandle handle, DataAccepter accepter) {
        logger.info("Init MsgDispatcher.");
        this.m_Handle = handle;
        this.accepter = accepter;
        this.unknownCommReceiver = new UnknownCommandReceiver(this.m_Handle);
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
        this.checker = new CommTimeoutChecker(this);
        this.checker.start();
    }

    public void addMessageReceiver(Character handleChar, MSGListener listener, int cmdCode, int times) {
        this.receivers.put(handleChar, listener);
        if (times >= 1000) {
            this.checker.addItem(handleChar, cmdCode, times);
        } else {
            this.checker.addItem(handleChar, cmdCode, this.m_Handle.timeout);
        }
    }

    public void addMessageListener(int cmdCode, MSGListener listener) {
        Integer codeObj = cmdCode;
        Vector<MSGListener> listeners = (Vector<MSGListener>)this.listenTable.get(codeObj);
        if (listeners == null) {
            listeners = new Vector<MSGListener>();
            listeners.addElement(listener);
            this.listenTable.put(codeObj, listeners);
        } else if (!listeners.contains(listener)) {
            listeners.addElement(listener);
        }
    }

    public void removeMessageListener(int cmdCode, MSGListener listener) {
        Integer ch = cmdCode;
        Vector listeners = (Vector)this.listenTable.get(ch);
        if (listeners != null) {
            listeners.removeElement(listener);
            if (listeners.isEmpty()) {
                this.listenTable.remove(ch);
            }
        }
    }

    public void removeMessageListener(int cmdCode) {
        Integer ch = cmdCode;
        Vector listeners = (Vector)this.listenTable.get(ch);
        if (listeners != null) {
            listeners.removeAllElements();
            this.listenTable.remove(ch);
        }
    }

    public void removeReceiver(Character ch) {
        this.receivers.remove(ch);
    }

    void removeReceiver(MSGListener listener) {
        if (listener == null) {
            logger.info("MSGListener is null");
            return;
        }
        Enumeration cmdHandles = this.receivers.keys();
        while (cmdHandles.hasMoreElements()) {
            Character cmdHandle = (Character)cmdHandles.nextElement();
            if (!listener.equals(this.receivers.get(cmdHandle))) continue;
            this.removeReceiver(cmdHandle);
            this.removeTimeoutItem(cmdHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelReceivers() {
        logger.error("invoke cancel receivers!");
        Enumeration enumeration = this.receivers.keys();
        while (enumeration.hasMoreElements()) {
            MSGListener mSGListener;
            Object obj = enumeration.nextElement();
            MSGListener msglistener = (MSGListener)this.receivers.get(obj);
            if (msglistener instanceof MSGSyncReceiver) {
                ((MSGSyncReceiver)msglistener).setFlag(-3);
                mSGListener = msglistener;
                synchronized (mSGListener) {
                    msglistener.notifyAll();
                }
                this.receivers.remove(obj);
                continue;
            }
            if (!(msglistener instanceof AppAidedMsgSyncReceiver)) continue;
            ((AppAidedMsgSyncReceiver)msglistener).setFlag(-3);
            mSGListener = msglistener;
            synchronized (mSGListener) {
                msglistener.notifyAll();
            }
            this.receivers.remove(obj);
        }
        if (null != this.m_Handle && this.m_Handle.isClosed()) {
            this.receivers.clear();
        }
    }

    void removeTimeoutItem(Character cmdHandle) {
        this.checker.removeItem(cmdHandle);
    }

    void refreshTimeoutValue(int newValue, Character cmdHandle) {
        this.checker.refreshTimeoutValue(newValue, cmdHandle);
    }

    boolean checkTimeout(Character cmdHandle) {
        MSGListener receiver = null;
        receiver = (MSGListener)this.receivers.get(cmdHandle);
        if (receiver instanceof AppAidedMsgListener) {
            ((AppAidedMsgListener)receiver).addTimeoutPacket();
            return false;
        }
        return true;
    }

    public void run() {
        while (this.running) {
            MSGPacketExt msg = this.accepter.getMessage();
            if (msg == null) {
                logger.info("MsgDispatcher(): MSGPacketExt is NULL");
                continue;
            }
            switch (msg.mheader.msgType) {
                case 1: 
                case 6: 
                case 9: 
                case 21: {
                    this.m_Handle.refresh();
                    logger.info("invoke MsgDispatcher's dispatchListener() method begin.");
                    this.dispatchListener(msg);
                    logger.info("invoke MsgDispatcher's dispatchListener() method end.");
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 17: 
                case 27: 
                case 28: {
                    this.m_Handle.refresh();
                    logger.info("invoke MsgDispatcher's dispatchReceiver() method begin.");
                    this.dispatchReceiver(msg);
                    logger.info("invoke MsgDispatcher's dispatchReceiver() method end.");
                    break;
                }
                case 5: {
                    if (msg.mheader.cmdCode != 0) break;
                    this.m_Handle.refresh();
                    break;
                }
            }
        }
        this.m_Handle = null;
        this.accepter = null;
        this.checker = null;
        logger.info("MsgDispatcher exited.");
    }

    private void dispatchListener(MSGPacketExt msg) {
        Integer code = msg.mheader.cmdCode;
        Vector listeners = (Vector)this.listenTable.get(code);
        if (listeners != null) {
            try {
                Object[] tempArray = listeners.toArray();
                for (int i = 0; i < tempArray.length; ++i) {
                    MSGListener listener = (MSGListener)tempArray[i];
                    listener.receiveMessage(msg);
                }
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
        } else {
            this.unknownCommReceiver.receiveMessage(msg);
        }
    }

    private void dispatchReceiver(MSGPacketExt packet) {
        char handle = packet.mheader.cmdHandle;
        Character handleObj = Character.valueOf(handle);
        MSGListener recv = (MSGListener)this.receivers.get(handleObj);
        if (recv != null) {
            try {
                if (recv instanceof AppAidedMsgListener) {
                    if (recv.receiveMessage(packet)) {
                        this.receivers.remove(handleObj);
                        this.checker.removeItem(handleObj);
                    }
                } else {
                    int timeout = this.checker.removeItem(handleObj);
                    logger.info("invoke MSGListener's receiveMessage() method." + packet);
                    if (recv.receiveMessage(packet)) {
                        this.receivers.remove(handleObj);
                    } else if (timeout > 0) {
                        this.checker.addItem(handleObj, packet.mheader.cmdCode, timeout);
                    }
                }
            }
            catch (Exception e) {
                logger.error("invoke MSGListener's receiveMessage() method error, cmdHandle=" + handle, (Throwable)e);
            }
        } else {
            logger.info("The receiver had been removed, cmdHandle=" + handle);
        }
    }

    void timeout(int cmdCode, Character cmdHandle) {
        MSGListener receiver = null;
        receiver = (MSGListener)this.receivers.remove(cmdHandle);
        if (receiver != null) {
            CommHandle.logTrace("MsgDispatcher timeout in: ", cmdCode, cmdHandle.charValue());
            receiver.timeout(cmdCode, cmdHandle);
            CommHandle.logTrace("MsgDispatcher timeout out: ", cmdCode, cmdHandle.charValue());
        }
    }

    public void cancelListeners() {
        logger.info("invoke cancel listeners");
        this.listenTable.clear();
    }

    public void close() {
        logger.info("Close MsgDispatcher.");
        this.running = false;
        if (this.checker != null) {
            this.checker.close();
        }
        this.cancelReceivers();
        this.cancelListeners();
    }
}

