/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import java.util.List;
import java.util.Vector;

public class MSGSyncReceiver
implements MSGListener {
    private List m_packets = new Vector();
    private int flag = 1;

    public final boolean receiveMessage(MSGPacketExt msg) {
        if (!this.isValidPacket(msg)) {
            return true;
        }
        this.m_packets.add(msg);
        if (this.isFinish(msg)) {
            this.notifyReceiver(0);
            return true;
        }
        return false;
    }

    private boolean isFinish(MSGPacketExt msg) {
        return (msg.mheader.commFlag & 0x80) == 0;
    }

    public final void timeout(int cmdCode, Character cmdHandle) {
        this.notifyReceiver(-1);
    }

    public final MSGPacketExt[] getResults() {
        int size = this.m_packets.size();
        if (size > 0) {
            MSGPacketExt[] msgs = new MSGPacketExt[size];
            this.m_packets.toArray(msgs);
            return msgs;
        }
        return new MSGPacketExt[0];
    }

    public final MSGPacketExt getResult() {
        if (!this.m_packets.isEmpty()) {
            return (MSGPacketExt)this.m_packets.get(0);
        }
        return null;
    }

    public void setFlag(int val) {
        this.flag = val;
    }

    public int getFlag() {
        return this.flag;
    }

    public void reset() {
        this.notifyReceiver(1);
        this.m_packets.clear();
    }

    final void cancel() {
        if (this.flag != 2) {
            return;
        }
        this.notifyReceiver(3);
        this.m_packets.clear();
    }

    private synchronized void notifyReceiver(int flag) {
        this.flag = flag;
        this.notifyAll();
    }

    private boolean isValidPacket(MSGPacketExt msg) {
        int result = CommUtil.checkValidPacket(msg);
        if (result == Integer.MIN_VALUE) {
            return true;
        }
        this.notifyReceiver(result);
        return false;
    }
}

