/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MSGReceiver
extends Thread
implements MSGListener {
    private static Logger logger = LoggerFactory.getLogger(MSGReceiver.class);
    private List buf = new ArrayList();
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean receiveMessage(MSGPacketExt msg) {
        if (msg != null && this.buf != null) {
            CommHandle.logTrace("MSGReceiver.receiveMessage", msg);
            if (this.isValidPacket(msg) || this.isDispatchInvalidPacket()) {
                List list = this.buf;
                synchronized (list) {
                    this.buf.add(msg);
                    this.buf.notifyAll();
                }
            } else {
                return false;
            }
            return this.isFinish(msg);
        }
        logger.info("MSGReceiver.receiveMessage, msg or buf is null");
        return true;
    }

    protected boolean isFinish(MSGPacketExt msg) {
        return (msg.mheader.commFlag & 0x80) == 0;
    }

    public MSGReceiver() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            while (this.running) {
                MSGPacketExt msg = null;
                List list = this.buf;
                synchronized (list) {
                    if (this.buf.isEmpty()) {
                        this.buf.wait();
                        if (this.buf.isEmpty()) {
                            break;
                        }
                    }
                    msg = (MSGPacketExt)this.buf.remove(0);
                }
                CommHandle.logTrace("MSGReceiver processMessage in: ", msg);
                this.processMessage(msg);
                CommHandle.logTrace("MSGReceiver processMessage out:", msg);
            }
        }
        catch (InterruptedException exp) {
            logger.error(this.getClass().getName() + " is interrupted.", (Throwable)exp);
        }
        this.buf.clear();
        this.buf = null;
    }

    public final void close() {
        this.running = false;
        this.interrupt();
    }

    private boolean isValidPacket(MSGPacketExt msg) {
        int result = CommUtil.checkValidPacket(msg);
        return result == Integer.MIN_VALUE;
    }

    protected abstract void processMessage(MSGPacketExt var1);

    protected boolean isDispatchInvalidPacket() {
        return false;
    }
}

